/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.screen.widget.tabs;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import es.degrassi.mmreborn.client.screen.widget.ItemOrIconButton;
import es.degrassi.mmreborn.client.screen.widget.tabs.BottomTabGroupWidget;
import es.degrassi.mmreborn.client.screen.widget.tabs.LeftTabGroupWidget;
import es.degrassi.mmreborn.client.screen.widget.tabs.RightTabGroupWidget;
import es.degrassi.mmreborn.client.screen.widget.tabs.TabWidget;
import es.degrassi.mmreborn.client.screen.widget.tabs.TopTabGroupWidget;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.inventory.tooltip.TooltipComponent;

public abstract class TabGroupWidget
extends AbstractWidget {
    protected final List<TabWidget> tabs = Lists.newArrayList();
    protected final AtomicInteger lastX = new AtomicInteger();
    protected final AtomicInteger lastY = new AtomicInteger();

    public TabGroupWidget(int x, int y, int width, int height, Component message) {
        super(x, y, width, height, message);
        this.lastX.set(x);
        this.lastY.set(y);
    }

    public abstract int getWidth();

    public abstract int getHeight();

    public TabGroupWidget addTab(TabWidget tab) {
        return this.addTab(0, 0, tab);
    }

    public abstract TabGroupWidget addTab(int var1, int var2, TabWidget var3);

    public TabGroupWidget addTab(ItemOrIconButton icon, @Nullable TabWidget.OnClick action) {
        return this.addTab(0, 0, icon, action);
    }

    public abstract TabGroupWidget addTab(int var1, int var2, ItemOrIconButton var3, @Nullable TabWidget.OnClick var4);

    public TabGroupWidget addTab(ItemOrIconButton icon) {
        return this.addTab(0, 0, icon);
    }

    public abstract TabGroupWidget addTab(int var1, int var2, ItemOrIconButton var3);

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.tabs.forEach(tab -> tab.render(guiGraphics, mouseX, mouseY, partialTick));
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        this.tabs.forEach(tab -> tab.updateWidgetNarration(narrationElementOutput));
    }

    public void onClick(double mouseX, double mouseY, int button) {
        this.getTabUnderMouse(mouseX, mouseY).ifPresent(tab -> tab.onClick(mouseX, mouseY, button));
    }

    private Optional<TabWidget> getTabUnderMouse(double mouseX, double mouseY) {
        return this.tabs.stream().filter(tab -> tab.isMouseOver(mouseX, mouseY)).filter(AbstractWidget::isActive).findFirst();
    }

    public void setInitialFocus(int lastFocus) {
        if (lastFocus < 0) {
            lastFocus = 0;
        }
        if (lastFocus >= this.tabs.size()) {
            lastFocus = this.tabs.size() - 1;
        }
        this.tabs.forEach(tab -> tab.setFocused(false));
        this.tabs.get(lastFocus).setFocused(true);
    }

    public void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        this.tabs.stream().filter(tab -> tab.isMouseOver(x, y)).forEach(tab -> tab.renderTooltip(guiGraphics, x, y));
    }

    public void gatherComponents(List<Either<FormattedText, TooltipComponent>> components) {
        this.tabs.forEach(tab -> tab.gatherComponents(components));
    }

    public static LeftTabGroupWidget createLeft(int x, int y) {
        return new LeftTabGroupWidget(x, y);
    }

    public static RightTabGroupWidget createRight(int x, int y) {
        return new RightTabGroupWidget(x, y);
    }

    public static TopTabGroupWidget createTop(int x, int y) {
        return new TopTabGroupWidget(x, y);
    }

    public static BottomTabGroupWidget createBottom(int x, int y) {
        return new BottomTabGroupWidget(x, y);
    }

    @Generated
    public List<TabWidget> getTabs() {
        return this.tabs;
    }
}

