/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.screen.widget.tabs;

import es.degrassi.mmreborn.client.container.ControllerContainer;
import es.degrassi.mmreborn.client.screen.ControllerScreen;
import es.degrassi.mmreborn.client.screen.popup.ConfirmationPopup;
import es.degrassi.mmreborn.client.screen.widget.ItemOrIconButton;
import es.degrassi.mmreborn.client.screen.widget.tabs.TopTabWidget;
import es.degrassi.mmreborn.common.entity.MachineControllerEntity;
import es.degrassi.mmreborn.common.network.client.CBreakStructurePacket;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.network.PacketDistributor;

@ParametersAreNonnullByDefault
public class StructureBreakWidget
extends TopTabWidget {
    private final ControllerScreen parentScreen;
    private final ResourceLocation machine;
    private final BlockPos controllerPos;
    public final Component component = Component.translatable((String)"modular_machinery_reborn.gui.structure_breaker_button");

    public StructureBreakWidget(ControllerScreen parentScreen, ResourceLocation machine, BlockPos controllerPos) {
        super(0, 0, new ItemOrIconButton(5, 5, Items.DIAMOND_PICKAXE, button -> {}));
        this.parentScreen = parentScreen;
        this.machine = machine;
        this.controllerPos = controllerPos;
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        guiGraphics.renderTooltip(Minecraft.getInstance().font, List.of(this.component.getVisualOrderText()), x, y);
    }

    @Override
    public void onClick(double mouseX, double mouseY, int button) {
        this.parentScreen.setFocused((GuiEventListener)this);
        ((MachineControllerEntity)((ControllerContainer)this.parentScreen.getMenu()).getEntity()).setLastFocus(1);
        this.parentScreen.openPopup(new ConfirmationPopup<ControllerContainer>(this.parentScreen, 180, 96, () -> PacketDistributor.sendToServer((CustomPacketPayload)new CBreakStructurePacket(this.machine, this.controllerPos), (CustomPacketPayload[])new CustomPacketPayload[0])).text(new Component[]{Component.translatable((String)"mmr.gui.structure.break"), Component.empty(), Component.empty()}), "popup");
    }
}

