/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.screen.widget.tabs;

import es.degrassi.mmreborn.client.screen.widget.ItemOrIconButton;
import es.degrassi.mmreborn.client.screen.widget.tabs.TabGroupWidget;
import es.degrassi.mmreborn.client.screen.widget.tabs.TabWidget;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.chat.Component;

@ParametersAreNonnullByDefault
public class HorizontalTabGroupWidget
extends TabGroupWidget {
    public HorizontalTabGroupWidget(int x, int y) {
        super(x, y, 0, 0, (Component)Component.empty());
    }

    @Override
    public int getWidth() {
        return this.tabs.stream().mapToInt(TabWidget::getWidth).sum();
    }

    @Override
    public int getHeight() {
        return this.tabs.stream().mapToInt(TabWidget::getHeight).max().orElse(1);
    }

    @Override
    public HorizontalTabGroupWidget addTab(TabWidget tab) {
        return this.addTab(0, 0, tab);
    }

    @Override
    public HorizontalTabGroupWidget addTab(int xOffset, int yOffset, TabWidget tab) {
        tab.setX(this.lastX.getAndAdd(tab.getWidth() + xOffset));
        tab.setY(this.getY() + yOffset);
        this.tabs.add(tab);
        return this;
    }

    @Override
    public HorizontalTabGroupWidget addTab(ItemOrIconButton icon, @Nullable TabWidget.OnClick action) {
        return this.addTab(0, 0, icon, action);
    }

    @Override
    public HorizontalTabGroupWidget addTab(int xOffset, int yOffset, ItemOrIconButton icon, @Nullable TabWidget.OnClick action) {
        TabWidget tab = new TabWidget(this.lastX.get() + xOffset, this.getY() + yOffset, icon, action);
        this.lastX.getAndAdd(tab.getWidth() + xOffset);
        return this.addTab(tab);
    }

    @Override
    public HorizontalTabGroupWidget addTab(ItemOrIconButton icon) {
        return this.addTab(0, 0, icon);
    }

    @Override
    public HorizontalTabGroupWidget addTab(int xOffset, int yOffset, ItemOrIconButton icon) {
        TabWidget tab = new TabWidget(this.lastX.get() + xOffset, this.getY() + yOffset, icon);
        this.lastX.getAndAdd(tab.getWidth() + xOffset);
        return this.addTab(tab);
    }
}

