/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.screen.widget;

import com.google.common.collect.Lists;
import es.degrassi.mmreborn.api.client.Blitter;
import es.degrassi.mmreborn.api.client.Icon;
import es.degrassi.mmreborn.api.client.screen.TooltipRender;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class ItemOrIconButton
extends Button
implements TooltipRender {
    private boolean halfSize = false;
    private boolean disableClickSound = false;
    private boolean disableBackground = false;
    @Nullable
    private final Item item;
    @Nullable
    private final Icon icon;
    private boolean renderTooltip = true;
    private List<Component> tooltips;

    public ItemOrIconButton(int x, int y, Button.OnPress onPress) {
        super(x, y, 16, 16, (Component)Component.empty(), onPress, Button.DEFAULT_NARRATION);
        this.item = null;
        this.icon = null;
    }

    public ItemOrIconButton(int x, int y, Item item, Button.OnPress onPress) {
        super(x, y, 16, 16, (Component)Component.empty(), onPress, Button.DEFAULT_NARRATION);
        this.item = item;
        this.icon = null;
    }

    public ItemOrIconButton(int x, int y, Icon icon, Button.OnPress onPress) {
        super(x, y, 16, 16, (Component)Component.empty(), onPress, Button.DEFAULT_NARRATION);
        this.item = null;
        this.icon = icon;
    }

    public ItemOrIconButton(Button.Builder builder) {
        super(builder);
        this.item = null;
        this.icon = null;
    }

    public ItemOrIconButton renderTooltip(boolean render) {
        this.renderTooltip = render;
        return this;
    }

    public ItemOrIconButton setTooltips(Component ... components) {
        this.tooltips = Lists.newArrayList((Object[])components);
        return this;
    }

    public void setVisibility(boolean vis) {
        this.visible = vis;
        this.active = vis;
    }

    public void playDownSound(SoundManager soundHandler) {
        if (!this.disableClickSound) {
            super.playDownSound(soundHandler);
        }
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        if (this.visible) {
            int yOffset;
            Icon icon = this.getIcon();
            Item item = this.getItem();
            if (this.halfSize) {
                this.width = this.getWidth() / 2;
                this.height = this.getHeight() / 2;
            }
            int n = yOffset = this.isHovered() ? 1 : 0;
            if (this.halfSize) {
                if (!this.disableBackground) {
                    Icon.TOOLBAR_BUTTON_BACKGROUND.getBlitter().dest(this.getX(), this.getY()).zOffset(10).blit(guiGraphics);
                }
                if (item != null) {
                    guiGraphics.renderItem(new ItemStack((ItemLike)item), this.getX(), this.getY(), 0, 20);
                } else if (icon != null) {
                    Blitter blitter = icon.getBlitter();
                    if (!this.active) {
                        blitter.opacity(0.5f);
                    }
                    blitter.dest(this.getX(), this.getY()).zOffset(20).blit(guiGraphics);
                }
            } else {
                if (!this.disableBackground) {
                    Icon bgIcon = this.isHovered() ? Icon.TOOLBAR_BUTTON_BACKGROUND_HOVER : (this.isFocused() ? Icon.TOOLBAR_BUTTON_BACKGROUND_FOCUS : Icon.TOOLBAR_BUTTON_BACKGROUND);
                    bgIcon.getBlitter().dest(this.getX() - 1, this.getY() + yOffset, 18, 20).zOffset(2).blit(guiGraphics);
                }
                if (item != null) {
                    guiGraphics.renderItem(new ItemStack((ItemLike)item), this.getX(), this.getY() + 1 + yOffset, 0, 3);
                } else if (icon != null) {
                    icon.getBlitter().dest(this.getX(), this.getY() + 1 + yOffset).zOffset(3).blit(guiGraphics);
                }
            }
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.getTooltipArea().contains((int)mouseX, (int)mouseY);
    }

    public List<Component> getTooltipMessage() {
        return this.getTooltips();
    }

    public Rect2i getTooltipArea() {
        return new Rect2i(this.getX(), this.getY(), this.halfSize ? this.getWidth() / 2 : this.getWidth(), this.halfSize ? this.getHeight() / 2 : this.getHeight());
    }

    public boolean isTooltipAreaVisible() {
        return this.visible;
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY) && this.renderTooltip) {
            guiGraphics.renderTooltip(Minecraft.getInstance().font, this.getTooltipMessage().stream().map(Component::getVisualOrderText).toList(), mouseX, mouseY);
        }
    }

    public String toString() {
        return "ItemButton{halfSize=" + this.halfSize + ", disableClickSound=" + this.disableClickSound + ", disableBackground=" + this.disableBackground + ", item=" + String.valueOf(this.getItem() == null ? "null" : this.getItem()) + ", icon=" + String.valueOf(this.getIcon() == null ? "null" : this.getIcon()) + ", renderTooltip=" + this.renderTooltip + ", x=" + this.getX() + ", y=" + this.getY() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + "}";
    }

    @Generated
    public boolean isHalfSize() {
        return this.halfSize;
    }

    @Generated
    public boolean isDisableClickSound() {
        return this.disableClickSound;
    }

    @Generated
    public boolean isDisableBackground() {
        return this.disableBackground;
    }

    @Nullable
    @Generated
    public Item getItem() {
        return this.item;
    }

    @Nullable
    @Generated
    public Icon getIcon() {
        return this.icon;
    }

    @Generated
    public boolean isRenderTooltip() {
        return this.renderTooltip;
    }

    @Generated
    public List<Component> getTooltips() {
        return this.tooltips;
    }

    @Generated
    public void setHalfSize(boolean halfSize) {
        this.halfSize = halfSize;
    }

    @Generated
    public void setDisableClickSound(boolean disableClickSound) {
        this.disableClickSound = disableClickSound;
    }

    @Generated
    public void setDisableBackground(boolean disableBackground) {
        this.disableBackground = disableBackground;
    }

    @Generated
    public void setRenderTooltip(boolean renderTooltip) {
        this.renderTooltip = renderTooltip;
    }
}

