/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.screen.widget;

import es.degrassi.mmreborn.client.screen.BaseScreen;
import es.degrassi.mmreborn.client.screen.widget.IFancyFontRenderer;
import es.degrassi.mmreborn.client.util.GuiUtils;
import es.degrassi.mmreborn.common.util.MMRLogger;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IGuiWrapper
extends ContainerEventHandler,
IFancyFontRenderer {
    @NotNull
    default public ItemStack getCarriedItem() {
        return ItemStack.EMPTY;
    }

    public int getGuiLeft();

    public int getGuiTop();

    @Override
    public int getXSize();

    public int getYSize();

    default public boolean currentlyQuickCrafting() {
        return false;
    }

    default public void renderItem(GuiGraphics guiGraphics, @NotNull ItemStack stack, int xAxis, int yAxis) {
        this.renderItem(guiGraphics, stack, xAxis, yAxis, 1.0f);
    }

    default public void renderItem(GuiGraphics guiGraphics, @NotNull ItemStack stack, int xAxis, int yAxis, float scale) {
        GuiUtils.renderItem(guiGraphics, stack, xAxis, yAxis, scale, this.font(), null, false);
    }

    default public void renderItemTooltipWithExtra(GuiGraphics guiGraphics, @NotNull ItemStack stack, int xAxis, int yAxis, List<Component> toAppend) {
        if (toAppend.isEmpty()) {
            guiGraphics.renderTooltip(this.font(), stack, xAxis, yAxis);
        } else {
            ArrayList<Component> tooltip = new ArrayList<Component>(Screen.getTooltipFromItem((Minecraft)Minecraft.getInstance(), (ItemStack)stack));
            tooltip.addAll(toAppend);
            guiGraphics.renderTooltip(this.font(), tooltip, stack.getTooltipImage(), stack, xAxis, yAxis);
        }
    }

    default public void renderItemWithOverlay(GuiGraphics guiGraphics, @NotNull ItemStack stack, int xAxis, int yAxis, float scale, @Nullable String text) {
        GuiUtils.renderItem(guiGraphics, stack, xAxis, yAxis, scale, this.font(), text, true);
    }

    @Nullable
    default public BaseScreen<?, ?> getWindowHovering(double mouseX, double mouseY) {
        return null;
    }

    default public void addWindow(BaseScreen<?, ?> window) {
        MMRLogger.INSTANCE.error("Tried to call 'addWindow' but unsupported in {}", (Object)this.getClass().getName());
    }

    default public void removeWindow(BaseScreen<?, ?> window) {
        MMRLogger.INSTANCE.error("Tried to call 'removeWindow' but unsupported in {}", (Object)this.getClass().getName());
    }

    public void renderSlotHighlight(GuiGraphics var1, Slot var2, int var3, int var4, float var5);

    public int getSlotColor(int var1);

    public int getSlotColor();

    default public void renderSlotHighlight(GuiGraphics guiGraphics, Slot slot, int mouseX, int mouseY, float partialTick, int z) {
        if (slot.isHighlightable()) {
            BaseScreen.renderSlotHighlight(guiGraphics, slot.x, slot.y, this.getSlotColor(slot.index), z);
        }
    }
}

