/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.screen.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import es.degrassi.mmreborn.client.container.SlotItemComponent;
import es.degrassi.mmreborn.client.screen.BaseScreen;
import es.degrassi.mmreborn.client.screen.widget.GuiElement;
import es.degrassi.mmreborn.client.screen.widget.GuiScrollbar;
import es.degrassi.mmreborn.client.screen.widget.IFancyFontRenderer;
import es.degrassi.mmreborn.client.screen.widget.ISlotClickHandler;
import es.degrassi.mmreborn.common.util.TextComponentUtil;
import es.degrassi.mmreborn.common.util.TextureSizeHelper;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.TextUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiSlotScroll
extends GuiElement {
    private static final Component ZERO = Component.literal((String)"").withStyle(ChatFormatting.YELLOW);
    private final GuiScrollbar scrollBar;
    private final int xSlots;
    private final int ySlots;
    private final Supplier<@NotNull List<SlotItemComponent>> slotList;
    private final ISlotClickHandler clickHandler;

    public GuiSlotScroll(BaseScreen<?, ?> gui, int x, int y, int xSlots, int ySlots, Supplier<@NotNull List<SlotItemComponent>> slotList, ISlotClickHandler clickHandler, boolean needsScrolling) {
        super(gui, x, y, xSlots * 18 + BaseScreen.getScrollbarWidth() + 8, ySlots * 18);
        this.xSlots = xSlots;
        this.ySlots = ySlots;
        this.slotList = slotList;
        this.clickHandler = clickHandler;
        this.scrollBar = this.addChild(new GuiScrollbar(gui, this.relativeX + xSlots * 18 + 4, y, ySlots * 18, () -> Mth.ceil((double)((double)this.getSlotList().size() / (double)this.xSlots)), () -> this.ySlots, needsScrolling));
    }

    @Override
    public void visitWidgets(@NotNull Consumer<AbstractWidget> consumer) {
        this.children().forEach(consumer);
    }

    public List<SlotItemComponent> getSlotList() {
        return this.slotList.get();
    }

    @Override
    public void drawBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(guiGraphics, mouseX, mouseY, partialTicks);
        List<SlotItemComponent> list = this.getSlotList();
        if (!list.isEmpty()) {
            int slot;
            int slotStart = this.scrollBar.getCurrentSelection() * this.xSlots;
            int max = this.xSlots * this.ySlots;
            for (int i = 0; i < max && (slot = slotStart + i) < list.size(); ++i) {
                this.renderSlot(guiGraphics, list.get(slot), 18 * (i % this.xSlots) + this.relativeX - 1, 18 * (i / this.xSlots) + this.relativeY - 1);
            }
        }
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderForeground(guiGraphics, mouseX, mouseY);
        if (this.getSlot(mouseX, mouseY) == null) {
            return;
        }
        int xAxis = mouseX - this.getGuiLeft();
        int yAxis = mouseY - this.getGuiTop();
        int slotX = (xAxis - this.relativeX) / 18;
        int slotY = (yAxis - this.relativeY) / 18;
        if (slotX >= 0 && slotY >= 0 && slotX < this.xSlots && slotY < this.ySlots) {
            int slotStartX = this.relativeX + slotX * 18;
            int slotStartY = this.relativeY + slotY * 18;
            if (xAxis >= slotStartX && xAxis < slotStartX + 18 - 2 && yAxis >= slotStartY && yAxis < slotStartY + 18 - 2 && this.checkWindows(mouseX, mouseY)) {
                guiGraphics.blit(BaseScreen.BASE_SLOT_HOVERED, slotStartX - 1, slotStartY - 1, 0.0f, 0.0f, 18, 18, TextureSizeHelper.getWidth(BaseScreen.BASE_SLOT_HOVERED), TextureSizeHelper.getHeight(BaseScreen.BASE_SLOT_HOVERED));
                BaseScreen.renderSlotHighlight(guiGraphics, slotStartX, slotStartY, this.gui().getSlotColor(), 0);
                this.renderToolTip(guiGraphics, mouseX, mouseY);
            }
        }
    }

    @Override
    public void renderToolTip(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderToolTip(guiGraphics, mouseX, mouseY);
        SlotItemComponent slot = this.getSlot(mouseX, mouseY);
        if (slot != null) {
            this.renderSlotTooltip(guiGraphics, slot, mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double xDelta, double yDelta) {
        return this.scrollBar.adjustScroll(yDelta) || super.mouseScrolled(mouseX, mouseY, xDelta, yDelta);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return Optional.ofNullable(this.getSlot(mouseX, mouseY)).map(slot -> {
            boolean flag;
            if (!slot.isActive()) {
                return false;
            }
            this.getChildAt(mouseX, mouseY).ifPresentOrElse(this::setFocused, () -> this.gui().clearFocus());
            if (this.active && this.visible && this.isValidClickButton(button) && (flag = this.clicked(mouseX, mouseY))) {
                this.playDownSound(Minecraft.getInstance().getSoundManager());
                this.onClick(mouseX, mouseY, button);
                return true;
            }
            return false;
        }).orElse(false);
    }

    protected boolean isValidClickButton(int button) {
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.gui().currentlyQuickCrafting()) {
            return super.mouseReleased(mouseX, mouseY, button);
        }
        super.mouseReleased(mouseX, mouseY, button);
        this.clickHandler.onClick(() -> this.getSlot(mouseX, mouseY), button, Screen.hasShiftDown(), this.gui().getCarriedItem());
        return true;
    }

    @Nullable
    private SlotItemComponent getSlot(double mouseX, double mouseY) {
        List<SlotItemComponent> list = this.getSlotList();
        if (list.isEmpty()) {
            return null;
        }
        int slotX = (int)((mouseX - (double)this.getX()) / 18.0);
        int slotY = (int)((mouseY - (double)this.getY()) / 18.0);
        int slotStartX = this.getX() + slotX * 18 + 1;
        int slotStartY = this.getY() + slotY * 18 + 1;
        if (mouseX < (double)slotStartX || mouseX >= (double)(slotStartX + 18 - 2) || mouseY < (double)slotStartY || mouseY >= (double)(slotStartY + 18 - 2)) {
            return null;
        }
        if (slotX < 0 || slotY < 0 || slotX >= this.xSlots || slotY >= this.ySlots) {
            return null;
        }
        int slot = (slotY + this.scrollBar.getCurrentSelection()) * this.xSlots + slotX;
        if (slot >= list.size()) {
            return null;
        }
        return list.get(slot);
    }

    private void renderSlot(GuiGraphics guiGraphics, SlotItemComponent slot, int slotX, int slotY) {
        guiGraphics.blit(BaseScreen.BASE_SLOT, slotX, slotY, 0.0f, 0.0f, TextureSizeHelper.getWidth(BaseScreen.BASE_SLOT), TextureSizeHelper.getHeight(BaseScreen.BASE_SLOT), TextureSizeHelper.getWidth(BaseScreen.BASE_SLOT), TextureSizeHelper.getHeight(BaseScreen.BASE_SLOT));
        ItemStack stack = slot.getItem();
        if (stack.isEmpty()) {
            return;
        }
        this.gui().renderItemWithOverlay(guiGraphics, stack, this.relativeX + slotX + 2 - 9, this.relativeY + slotY + 1 - 9, 1.0f, "");
        long count = slot.getItem().getCount();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
        Object text = null;
        if (count == 0L) {
            text = ZERO;
        } else if (count > 1L) {
            text = count < 100L ? TextComponentUtil.getString(Long.toString(count)) : UnitDisplayUtils.getDisplay((double)count, (int)1);
        }
        if (text != null) {
            this.renderSlotText(guiGraphics, (Component)text, slotX + 2 - 9, slotY + 1 - 9);
        }
        guiGraphics.pose().popPose();
    }

    private void renderSlotTooltip(GuiGraphics guiGraphics, SlotItemComponent slot, int slotX, int slotY) {
        ItemStack stack = slot.getItem();
        if (stack.isEmpty()) {
            return;
        }
        long count = slot.getItem().getCount();
        if (count < 100L) {
            guiGraphics.renderTooltip(this.font(), stack, slotX - this.getGuiLeft(), slotY - this.getGuiTop());
        } else {
            this.gui().renderItemTooltipWithExtra(guiGraphics, stack, slotX - this.getGuiLeft(), slotY - this.getGuiTop(), Collections.singletonList(Component.literal((String)TextUtils.format((long)count)).withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)TextUtils.format((long)slot.getMaxStackSize())).withStyle(ChatFormatting.GOLD))));
        }
    }

    private void renderSlotText(GuiGraphics guiGraphics, Component text, int x, int y) {
        float scale = 0.6f;
        float scaledWidth = (float)this.font().width((FormattedText)text) * scale;
        if (scaledWidth >= 16.0f) {
            scale = 0.5f;
        }
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        pose.translate(0.0f, 0.0f, 200.0f);
        this.drawScaledScrollingString(guiGraphics, text, x, y + 9, IFancyFontRenderer.TextAlignment.RIGHT, 0xFFFFFF, 16, 0, true, scale);
        pose.popPose();
    }
}

