/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.screen.widget;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.client.screen.BaseScreen;
import es.degrassi.mmreborn.client.screen.widget.GuiScrollableElement;
import es.degrassi.mmreborn.common.util.TextureSizeHelper;
import java.util.function.IntSupplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class GuiScrollbar
extends GuiScrollableElement {
    private static final ResourceLocation BAR = ModularMachineryReborn.rl("small_scroller");
    private static final ResourceLocation BACK_BAR = ModularMachineryReborn.rl("small_scroller_disabled");
    private static final int TEXTURE_WIDTH = TextureSizeHelper.getWidth(BAR.withPrefix("textures/gui/sprites/"));
    private static final int TEXTURE_HEIGHT = TextureSizeHelper.getHeight(BAR.withPrefix("textures/gui/sprites/"));
    private final IntSupplier maxElements;
    private final IntSupplier focusedElements;
    private final boolean needsScrolling;

    public GuiScrollbar(BaseScreen<?, ?> gui, int x, int y, int height, IntSupplier maxElements, IntSupplier focusedElements, boolean needsScrolling) {
        super(BAR, BACK_BAR, gui, x, y, TEXTURE_WIDTH, height, 1, -1, TEXTURE_WIDTH * 3 / 2, TEXTURE_HEIGHT, height);
        this.maxElements = maxElements;
        this.focusedElements = focusedElements;
        this.needsScrolling = needsScrolling;
    }

    @Override
    public void drawBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.needsScrolling) {
            guiGraphics.blitSprite(BACK_BAR, this.barX, this.barY, 0, this.barWidth, this.height);
            guiGraphics.blitSprite(this.getResource(), this.barX, this.barY + this.getScroll(), 0, this.barWidth, this.barHeight);
        }
    }

    @Override
    protected int getMaxElements() {
        return this.maxElements.getAsInt();
    }

    @Override
    protected int getFocusedElements() {
        return this.focusedElements.getAsInt();
    }
}

