/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.screen.widget;

import es.degrassi.mmreborn.client.screen.BaseScreen;
import es.degrassi.mmreborn.client.screen.widget.GuiElement;
import es.degrassi.mmreborn.client.screen.widget.GuiTexturedElement;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public abstract class GuiScrollableElement
extends GuiTexturedElement {
    protected double scroll;
    private int dragOffset;
    protected final int maxBarHeight;
    protected final int barWidth;
    protected final int barHeight;
    protected final int barXShift;
    protected int barX;
    protected int barY;
    protected final ResourceLocation background;

    protected GuiScrollableElement(ResourceLocation resource, ResourceLocation background, BaseScreen<?, ?> gui, int x, int y, int width, int height, int barXShift, int barYShift, int barWidth, int barHeight, int maxBarHeight) {
        super(resource, gui, x, y, width, height);
        this.barXShift = barXShift;
        this.barX = this.relativeX + barXShift;
        this.barY = this.relativeY + barYShift;
        this.barWidth = barWidth;
        this.barHeight = barHeight;
        this.maxBarHeight = maxBarHeight;
        this.background = background;
    }

    @Override
    public void move(int changeX, int changeY) {
        super.move(changeX, changeY);
        this.barX += changeX;
        this.barY += changeY;
    }

    protected abstract int getMaxElements();

    protected abstract int getFocusedElements();

    public void onClick(double mouseX, double mouseY, int button) {
        super.onClick(mouseX, mouseY, button);
        int scroll = this.getScroll();
        int x = this.getGuiLeft() + this.barX;
        int y = this.getGuiTop() + this.barY;
        if (mouseX >= (double)x && mouseX <= (double)(x + this.barWidth) && mouseY >= (double)(y + scroll) && mouseY <= (double)(y + scroll + this.barHeight)) {
            if (this.needsScrollBars()) {
                double yAxis = mouseY - (double)this.getGuiTop();
                this.dragOffset = (int)(yAxis - (double)(scroll + this.barY));
                this.setDragging(true);
            } else {
                this.scroll = 0.0;
            }
        }
    }

    @Override
    public void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
        super.onDrag(mouseX, mouseY, deltaX, deltaY);
        if (this.isDragging() && this.needsScrollBars()) {
            double yAxis = mouseY - (double)this.getGuiTop();
            this.scroll = Mth.clamp((double)((yAxis - (double)this.barY - (double)this.dragOffset) / (double)this.getMax()), (double)0.0, (double)1.0);
        }
    }

    @Override
    public void onRelease(double mouseX, double mouseY) {
        super.onRelease(mouseX, mouseY);
        this.dragOffset = 0;
    }

    protected boolean needsScrollBars() {
        return this.getMaxElements() > this.getFocusedElements();
    }

    protected final int getElements() {
        return this.getMaxElements() - this.getFocusedElements();
    }

    protected int getScrollElementScaler() {
        return 1;
    }

    private int getMax() {
        return this.maxBarHeight - this.barHeight;
    }

    protected int getScroll() {
        int max = this.getMax();
        return Mth.clamp((int)((int)(this.scroll * (double)max)), (int)0, (int)max);
    }

    public int getCurrentSelection() {
        return this.needsScrollBars() ? (int)(((double)this.getElements() + 0.5) * this.scroll) : 0;
    }

    public boolean adjustScroll(double delta) {
        int elements;
        if (delta != 0.0 && this.needsScrollBars() && (elements = Mth.ceil((double)((double)this.getElements() / (double)this.getScrollElementScaler()))) > 0) {
            delta = delta > 0.0 ? 1.0 : -1.0;
            this.scroll = (float)Mth.clamp((double)(this.scroll - delta / (double)elements), (double)0.0, (double)1.0);
            return true;
        }
        return false;
    }

    protected void drawScrollBar(GuiGraphics guiGraphics, int textureWidth, int textureHeight) {
        ResourceLocation texture = this.getResource();
        guiGraphics.blit(texture, this.barX - 1, this.barY - 1, 0.0f, 0.0f, textureWidth, 1, textureWidth, textureHeight);
        guiGraphics.blit(texture, this.barX - 1, this.barY, textureWidth, this.maxBarHeight, 0.0f, 1.0f, textureWidth, 1, textureWidth, textureHeight);
        guiGraphics.blit(texture, this.barX - 1, this.relativeY + this.maxBarHeight + 2, 0.0f, 0.0f, textureWidth, 1, textureWidth, textureHeight);
        guiGraphics.blit(texture, this.barX, this.barY + this.getScroll(), 0.0f, 2.0f, this.barWidth, this.barHeight, textureWidth, textureHeight);
    }

    @Override
    public boolean hasPersistentData() {
        return true;
    }

    @Override
    public void syncFrom(GuiElement element) {
        super.syncFrom(element);
        GuiScrollableElement old = (GuiScrollableElement)element;
        if (this.needsScrollBars() && old.needsScrollBars()) {
            this.scroll = old.scroll;
        }
    }
}

