/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.screen.widget;

import com.google.common.collect.Lists;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.capability.IFuelHandler;
import es.degrassi.mmreborn.common.util.TextureSizeHelper;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class FuelWidget
extends AbstractWidget {
    private static final ResourceLocation emptyTexture = ModularMachineryReborn.rl("textures/gui/empty_fuel.png");
    private static final ResourceLocation filledTexture = ModularMachineryReborn.rl("textures/gui/filled_fuel.png");
    private final IFuelHandler handler;

    public FuelWidget(int x, int y, IFuelHandler handler) {
        super(x, y, TextureSizeHelper.getWidth(emptyTexture), TextureSizeHelper.getHeight(emptyTexture), (Component)Component.empty());
        this.handler = handler;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int i, int i1, float v) {
        guiGraphics.blit(emptyTexture, this.getX(), this.getY(), 0.0f, 0.0f, this.getWidth(), this.getHeight(), this.getWidth(), this.getHeight());
        int calcHeight = (int)((double)this.handler.getFuel() * 1.0 / (double)this.handler.getMaxFuel() * (double)this.getHeight());
        int offset = this.getHeight() - calcHeight;
        guiGraphics.blit(filledTexture, this.getX() + 1, this.getY() + offset + 1, 0.0f, (float)offset, this.getWidth(), calcHeight, this.getWidth(), this.getHeight());
    }

    public void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        ArrayList text = Lists.newArrayList();
        text.add(Component.translatable((String)"tooltip.fuel_tank.tank", (Object[])new Object[]{String.valueOf(this.handler.getFuel()), String.valueOf(this.handler.getMaxFuel())}));
        Font font = Minecraft.getInstance().font;
        guiGraphics.renderTooltip(font, text.stream().map(Component::getVisualOrderText).toList(), x, y);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

