/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.screen.widget;

import com.google.common.collect.Lists;
import es.degrassi.experiencelib.util.ExperienceUtils;
import es.degrassi.mmreborn.common.entity.base.ExperienceHatchEntity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;

public class ExperienceWidget
extends AbstractWidget {
    private final ExperienceHatchEntity entity;

    public ExperienceWidget(int x, int y, int screenWidth, ExperienceHatchEntity entity) {
        super(x + 8, y, screenWidth - 16, 16, (Component)Component.empty());
        this.entity = entity;
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.visible) {
            long level = ExperienceUtils.getLevelFromXp((long)this.entity.getTank().getExperience());
            String levels = "" + level;
            int xPos = this.getX() + this.width / 2 - Minecraft.getInstance().font.width(levels) / 2;
            graphics.drawString(Minecraft.getInstance().font, levels, xPos, this.getY(), 8453920, true);
            graphics.fill(this.getX(), this.getY() + 9, this.getX() + this.width, this.getY() + 12, -16777216);
            long xpDiff = this.entity.getTank().getExperience() - ExperienceUtils.getXpFromLevel((long)level);
            if (xpDiff > 0L) {
                double percent = (double)xpDiff / (double)ExperienceUtils.getXpNeededForNextLevel((long)level);
                graphics.fill(this.getX() + 1, this.getY() + 10, this.getX() + 1 + Math.max((int)Math.ceil((double)this.width * percent) - 2, 0), this.getY() + 11, -8323296);
            }
        }
    }

    public void playDownSound(SoundManager handler) {
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }

    public List<FormattedCharSequence> getTooltipMessage() {
        String literal = ExperienceUtils.format((long)this.entity.getTank().getExperience());
        String capacityLiteral = ExperienceUtils.format((long)this.entity.getTank().getExperienceCapacity()) + "XP";
        String level = "" + ExperienceUtils.getLevelFromXp((long)this.entity.getTank().getExperience());
        String capacityLevel = ExperienceUtils.getLevelFromXp((long)this.entity.getTank().getExperienceCapacity()) + " levels";
        return Lists.newArrayList((Object[])new MutableComponent[]{Component.translatable((String)"mmr.gui.element.experience.tooltip", (Object[])new Object[]{literal, capacityLiteral}).withStyle(ChatFormatting.GRAY), Component.translatable((String)"mmr.gui.element.experience.tooltip", (Object[])new Object[]{level, capacityLevel}).withStyle(ChatFormatting.GRAY)}).stream().map(Component::getVisualOrderText).toList();
    }
}

