/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.screen.widget;

import es.degrassi.mmreborn.api.client.ComponentTranslatable;
import es.degrassi.mmreborn.client.screen.widget.StringButton;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class EnumButton<E extends Enum<E>>
extends StringButton {
    private final Function<E, Component> messageFunction;
    private final List<E> values;
    private E value;
    private final Font font;

    public EnumButton(Button.Builder builder, Function<E, Component> messageFunction, List<E> values, E defaultValue) {
        super(builder, true);
        this.font = Minecraft.getInstance().font;
        this.messageFunction = messageFunction;
        this.values = values;
        this.value = this.values.contains(defaultValue) ? defaultValue : (Enum)this.values.get(0);
        this.renderTooltip(true);
    }

    public int getWidth() {
        return 8 + Math.min(this.font.width((FormattedText)this.getMessage()), 100);
    }

    public int getHeight() {
        return Math.max(8 + this.font.wordWrapHeight((FormattedText)this.getMessage(), this.getWidth() - 8), 20);
    }

    public void onPress() {
        this.value = this.getNextValue();
        super.onPress();
    }

    @Override
    public List<Component> getTooltips() {
        return Collections.singletonList(Component.translatable((String)"mmr.gui.tooltip.button.enum.cycle", (Object[])new Object[]{((ComponentTranslatable)this.getNextValue()).getTranslation()}));
    }

    public Component getMessage() {
        return this.messageFunction.apply(this.value);
    }

    public E getNextValue() {
        int index = this.values.indexOf(this.value);
        index = index < this.values.size() - 1 ? ++index : 0;
        return (E)((Enum)this.values.get(index));
    }

    @Generated
    public E getValue() {
        return this.value;
    }
}

