/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.screen.popup;

import com.google.common.collect.Maps;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.client.screen.TooltipRender;
import es.degrassi.mmreborn.client.screen.popup.PopupScreen;
import es.degrassi.mmreborn.common.util.LRU;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public abstract class BasePopupScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    protected static final ResourceLocation BLANK_BACKGROUND = ModularMachineryReborn.rl("background");
    public int x;
    public int y;
    public int xSize;
    public int ySize;
    private final LRU<PopupScreen<?>> popups = new LRU();
    private final Map<PopupScreen<?>, String> popupToId = Maps.newHashMap();
    private int freezePopupsTicks;
    private final Inventory playerInventory;

    protected BasePopupScreen(T pMenu, Inventory pPlayerInventory, Component component, int xSize, int ySize) {
        super(pMenu, pPlayerInventory, component);
        this.xSize = xSize;
        this.ySize = ySize;
        this.playerInventory = pPlayerInventory;
    }

    public void openPopup(PopupScreen<?> popup) {
        if (this.popups.contains(popup)) {
            return;
        }
        this.setFocused(null);
        this.popups.add(popup);
        popup.init(Minecraft.getInstance(), this.width, this.height);
    }

    public void openPopup(PopupScreen<?> popup, String id) {
        if (this.popupToId.containsValue(id)) {
            return;
        }
        this.popupToId.put(popup, id);
        this.openPopup(popup);
        this.freezePopupsTicks = 40;
    }

    public void closePopup(PopupScreen<?> popup) {
        popup.removed();
        this.popups.remove(popup);
        this.popupToId.remove(popup);
    }

    public Collection<PopupScreen<?>> popups() {
        return this.popups;
    }

    @Nullable
    public PopupScreen<?> getPopupUnderMouse(double mouseX, double mouseY) {
        return this.popups.stream().filter(popup -> mouseX >= (double)popup.x && mouseX <= (double)(popup.x + popup.xSize) && mouseY >= (double)popup.y && mouseY <= (double)(popup.y + popup.ySize)).findFirst().orElse(null);
    }

    public void removed() {
        this.popups.forEach(BasePopupScreen::removed);
    }

    protected void init() {
        super.init();
        this.x = (this.width - this.xSize) / 2;
        this.y = (this.height - this.ySize) / 2;
        this.popups.forEach(popup -> popup.init(Minecraft.getInstance(), this.width, this.height));
    }

    public void containerTick() {
        this.popups.forEach(BasePopupScreen::containerTick);
        if (this.freezePopupsTicks > 0) {
            --this.freezePopupsTicks;
        }
    }

    public void resize(Minecraft minecraft, int width, int height) {
        this.x = (width - this.xSize) / 2;
        this.y = (height - this.ySize) / 2;
        super.resize(minecraft, width, height);
    }

    public abstract void renderBackground(GuiGraphics var1, int var2, int var3, float var4);

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        PopupScreen<?> hoveredPopup = this.getPopupUnderMouse(mouseX, mouseY);
        graphics.pose().pushPose();
        if (hoveredPopup != null) {
            this.renderBackground(graphics, Integer.MAX_VALUE, Integer.MAX_VALUE, partialTicks);
        } else {
            this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        }
        LRU.LRUIterator iterator = this.popups.descendingIterator();
        while (iterator.hasNext()) {
            graphics.pose().translate(0.0f, 0.0f, 305.0f);
            PopupScreen popup = (PopupScreen)((Object)iterator.next());
            if (hoveredPopup == popup) {
                popup.renderWithTooltip(graphics, mouseX, mouseY, partialTicks);
                continue;
            }
            popup.render(graphics, Integer.MAX_VALUE, Integer.MAX_VALUE, partialTicks);
        }
        graphics.pose().popPose();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (PopupScreen popupScreen : this.popups) {
            if (!popupScreen.isMouseOver(mouseX, mouseY)) continue;
            boolean clicked = popupScreen.mouseClicked(mouseX, mouseY, button);
            if (this.freezePopupsTicks <= 0) {
                this.popups.moveUp(popupScreen);
            }
            return clicked;
        }
        for (GuiEventListener guiEventListener : this.children()) {
            if (!guiEventListener.mouseClicked(mouseX, mouseY, button)) continue;
            this.setFocused(guiEventListener);
            if (button == 0) {
                this.setDragging(true);
            }
            return true;
        }
        return false;
    }

    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.getChildAt(mouseX, mouseY).filter(listener -> listener instanceof TooltipRender).map(listener -> (TooltipRender)listener).ifPresent(render -> render.renderTooltip(guiGraphics, mouseX, mouseY));
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        for (PopupScreen popupScreen : this.popups) {
            if (!popupScreen.isMouseOver(mouseX, mouseY)) continue;
            boolean released = popupScreen.mouseReleased(mouseX, mouseY, button);
            if (this.freezePopupsTicks <= 0) {
                this.popups.moveUp(popupScreen);
            }
            return released;
        }
        this.setDragging(false);
        if (this.getFocused() != null && this.getFocused().mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        return this.getChildAt(mouseX, mouseY).filter(guiEventListener -> guiEventListener.mouseReleased(mouseX, mouseY, button)).isPresent();
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        LRU.LRUIterator lRUIterator = this.popups.iterator();
        if (lRUIterator.hasNext()) {
            PopupScreen popup = (PopupScreen)((Object)lRUIterator.next());
            boolean dragged = popup.mouseDragged(mouseX, mouseY, button, dragX, dragY);
            if (this.freezePopupsTicks <= 0) {
                this.popups.moveUp(popup);
            }
            return dragged;
        }
        return this.getFocused() != null && this.isDragging() && button == 0 && this.getFocused().mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        for (PopupScreen popupScreen : this.popups) {
            if (!popupScreen.isMouseOver(mouseX, mouseY)) continue;
            boolean scrolled = popupScreen.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
            if (this.freezePopupsTicks <= 0) {
                this.popups.moveUp(popupScreen);
            }
            return scrolled;
        }
        return this.getChildAt(mouseX, mouseY).filter(p_293596_ -> p_293596_.mouseScrolled(mouseX, mouseY, scrollX, scrollY)).isPresent();
    }

    /*
     * WARNING - void declaration
     */
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        FocusNavigationEvent.TabNavigation tabNavigation;
        FocusNavigationEvent.ArrowNavigation event;
        if (keyCode == 256) {
            if (!this.popups.isEmpty()) {
                PopupScreen toClose = this.getPopupUnderMouse(Minecraft.getInstance().mouseHandler.xpos(), Minecraft.getInstance().mouseHandler.ypos());
                if (toClose == null) {
                    toClose = (PopupScreen)((Object)this.popups.iterator().next());
                }
                this.closePopup(toClose);
                return true;
            }
            if (this.getFocused() != null && this.getFocused().keyPressed(keyCode, scanCode, modifiers)) {
                return true;
            }
            this.onClose();
            return true;
        }
        for (PopupScreen popupScreen : this.popups) {
            if (!popupScreen.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        if (this.getFocused() != null && this.getFocused().keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        switch (keyCode) {
            case 263: {
                FocusNavigationEvent.ArrowNavigation arrowNavigation = new FocusNavigationEvent.ArrowNavigation(ScreenDirection.LEFT);
                break;
            }
            case 262: {
                FocusNavigationEvent.ArrowNavigation arrowNavigation = new FocusNavigationEvent.ArrowNavigation(ScreenDirection.RIGHT);
                break;
            }
            case 265: {
                FocusNavigationEvent.ArrowNavigation arrowNavigation = new FocusNavigationEvent.ArrowNavigation(ScreenDirection.UP);
                break;
            }
            case 264: {
                FocusNavigationEvent.ArrowNavigation arrowNavigation = new FocusNavigationEvent.ArrowNavigation(ScreenDirection.DOWN);
                break;
            }
            case 258: {
                FocusNavigationEvent.ArrowNavigation arrowNavigation = new FocusNavigationEvent.TabNavigation(!Screen.hasShiftDown());
                break;
            }
            default: {
                FocusNavigationEvent.ArrowNavigation arrowNavigation = event = null;
            }
        }
        if (event != null) {
            void var5_9;
            ComponentPath componentPath = this.popups.stream().findFirst().map(arg_0 -> BasePopupScreen.lambda$keyPressed$7((FocusNavigationEvent)event, arg_0)).orElse(this.nextFocusPath((FocusNavigationEvent)event));
            if (componentPath == null && event instanceof FocusNavigationEvent.TabNavigation) {
                ComponentPath componentPath2 = this.getCurrentFocusPath();
                if (componentPath2 != null) {
                    componentPath2.applyFocus(false);
                }
                ComponentPath componentPath3 = super.nextFocusPath((FocusNavigationEvent)event);
            }
            if (var5_9 != null) {
                this.changeFocus((ComponentPath)var5_9);
            }
            return true;
        }
        if (keyCode == 256 && this.shouldCloseOnEsc()) {
            this.onClose();
            return true;
        }
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        switch (keyCode) {
            case 258: {
                FocusNavigationEvent.TabNavigation tabNavigation2 = this.createTabEvent();
                break;
            }
            case 262: {
                FocusNavigationEvent.TabNavigation tabNavigation2 = this.createArrowEvent(ScreenDirection.RIGHT);
                break;
            }
            case 263: {
                FocusNavigationEvent.TabNavigation tabNavigation2 = this.createArrowEvent(ScreenDirection.LEFT);
                break;
            }
            case 264: {
                FocusNavigationEvent.TabNavigation tabNavigation2 = this.createArrowEvent(ScreenDirection.DOWN);
                break;
            }
            case 265: {
                FocusNavigationEvent.TabNavigation tabNavigation2 = this.createArrowEvent(ScreenDirection.UP);
                break;
            }
            default: {
                FocusNavigationEvent.TabNavigation tabNavigation2 = tabNavigation = null;
            }
        }
        if (tabNavigation != null) {
            ComponentPath componentpath = super.nextFocusPath((FocusNavigationEvent)tabNavigation);
            if (componentpath == null && tabNavigation instanceof FocusNavigationEvent.TabNavigation) {
                this.clearFocus();
                componentpath = super.nextFocusPath((FocusNavigationEvent)tabNavigation);
            }
            if (componentpath != null) {
                this.changeFocus(componentpath);
            }
        }
        return false;
    }

    private FocusNavigationEvent.TabNavigation createTabEvent() {
        boolean flag = !BasePopupScreen.hasShiftDown();
        return new FocusNavigationEvent.TabNavigation(flag);
    }

    private FocusNavigationEvent.ArrowNavigation createArrowEvent(ScreenDirection direction) {
        return new FocusNavigationEvent.ArrowNavigation(direction);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        for (PopupScreen popupScreen : this.popups) {
            if (!popupScreen.keyReleased(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return this.getFocused() != null && this.getFocused().keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        for (PopupScreen popupScreen : this.popups) {
            if (!popupScreen.charTyped(codePoint, modifiers)) continue;
            return true;
        }
        return this.getFocused() != null && this.getFocused().charTyped(codePoint, modifiers);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        if (this.getPopupUnderMouse(mouseX, mouseY) != null) {
            return false;
        }
        return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.xSize) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.ySize);
    }

    public void setFocused(@Nullable GuiEventListener focused) {
        if (this.getFocused() != focused) {
            super.setFocused(focused);
        }
        if (focused != null) {
            this.popups.forEach(popup -> popup.setFocused(null));
        }
    }

    public static void blankBackground(GuiGraphics graphics, int x, int y, int width, int height) {
        graphics.blitSprite(BLANK_BACKGROUND, x, y, width, height);
    }

    public static void drawCenteredScaledString(GuiGraphics graphics, Font font, Component text, int x, int y, float scale, int color, boolean shadow) {
        graphics.pose().pushPose();
        graphics.pose().scale(scale, scale, 0.0f);
        int n = (int)(((float)x - (float)font.width((FormattedText)text) * scale / 2.0f) / scale);
        float f = y;
        Objects.requireNonNull(font);
        graphics.drawString(font, text, n, (int)((f - 9.0f / 2.0f) / scale), color, shadow);
        graphics.pose().popPose();
    }

    public static void drawScaledString(GuiGraphics graphics, Font font, Component text, int x, int y, float scale, int color, boolean shadow) {
        graphics.pose().pushPose();
        graphics.pose().scale(scale, scale, 0.0f);
        graphics.drawString(font, text, (int)((float)x / scale), (int)((float)y / scale), color, shadow);
        graphics.pose().popPose();
    }

    @Generated
    public Inventory getPlayerInventory() {
        return this.playerInventory;
    }

    private static /* synthetic */ ComponentPath lambda$keyPressed$7(FocusNavigationEvent event, PopupScreen popup) {
        return popup.nextFocusPath(event);
    }
}

