/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.screen;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.client.CoreActionType;
import es.degrassi.mmreborn.api.client.screen.TooltipRender;
import es.degrassi.mmreborn.client.container.ParallelHatchContainer;
import es.degrassi.mmreborn.client.screen.BaseScreen;
import es.degrassi.mmreborn.client.screen.widget.CoreActionButton;
import es.degrassi.mmreborn.common.entity.ParallelHatchEntity;
import es.degrassi.mmreborn.common.network.client.CCoreButtonClickedPacked;
import es.degrassi.mmreborn.common.util.TextureSizeHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class ParallelHatchScreen
extends BaseScreen<ParallelHatchContainer, ParallelHatchEntity> {
    public ParallelHatchScreen(ParallelHatchContainer menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title, false);
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
    }

    @Override
    @Nullable
    public ResourceLocation getTexture() {
        return ModularMachineryReborn.rl("background");
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        this.clearWidgets();
        if (this.getTexture() != null) {
            guiGraphics.pose().pushPose();
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            this.leftPos = (this.width - this.imageWidth) / 2;
            this.topPos = (this.height - this.imageHeight) / 2;
            guiGraphics.blitSprite(this.getTexture(), this.leftPos, this.topPos, 176, 176);
            guiGraphics.pose().popPose();
        }
        GridLayout layout = new GridLayout(this.leftPos + 8, this.topPos + 25);
        GridLayout.RowHelper row = layout.createRowHelper(5);
        row.defaultCellSetting().alignHorizontallyCenter().alignVerticallyMiddle().paddingHorizontal(20);
        row.addChild((LayoutElement)new CoreActionButton(this::action, CoreActionType.REMOVE).renderTooltip(true));
        row.addChild((LayoutElement)new MultiLineTextWidget((Component)Component.literal((String)String.format("%s", ((ParallelHatchEntity)((ParallelHatchContainer)this.getMenu()).getEntity()).getCores())), this.font), 3, row.newCellSettings().alignVerticallyMiddle().alignHorizontallyCenter());
        row.addChild((LayoutElement)new CoreActionButton(this::action, CoreActionType.ADD).renderTooltip(true));
        layout.arrangeElements();
        layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        for (Slot slot : ((ParallelHatchContainer)this.getMenu()).slots) {
            guiGraphics.blit(BASE_SLOT, slot.x + this.getGuiLeft() - 1, slot.y + this.getGuiTop() - 1, 0.0f, 0.0f, TextureSizeHelper.getWidth(BASE_SLOT), TextureSizeHelper.getHeight(BASE_SLOT), TextureSizeHelper.getWidth(BASE_SLOT), TextureSizeHelper.getHeight(BASE_SLOT));
        }
    }

    private void action(CoreActionType action) {
        int amount = Screen.hasShiftDown() ? 10 : (Screen.hasControlDown() ? -1 : 1);
        int minAmount = 1;
        int maxAmount = ((ParallelHatchEntity)((ParallelHatchContainer)this.getMenu()).getEntity()).getSize().max;
        int toSet = ((ParallelHatchEntity)((ParallelHatchContainer)this.getMenu()).getEntity()).getCores();
        if (action == CoreActionType.ADD) {
            if (amount == -1) {
                toSet = maxAmount;
            } else {
                toSet += amount;
                toSet = Math.min(maxAmount, toSet);
            }
        } else if (action == CoreActionType.REMOVE) {
            if (amount == -1) {
                toSet = minAmount;
            } else {
                toSet -= amount;
                toSet = Math.max(minAmount, toSet);
            }
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new CCoreButtonClickedPacked(((ParallelHatchEntity)((ParallelHatchContainer)this.getMenu()).getEntity()).getBlockPos(), toSet), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        this.children().stream().filter(listener -> listener instanceof TooltipRender).map(listener -> (TooltipRender)listener).forEach(renderer -> renderer.renderTooltip(guiGraphics, x, y));
    }
}

