/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import es.degrassi.mmreborn.client.container.ItemBusContainer;
import es.degrassi.mmreborn.client.container.SlotItemComponent;
import es.degrassi.mmreborn.client.screen.BaseScreen;
import es.degrassi.mmreborn.client.screen.widget.GuiElement;
import es.degrassi.mmreborn.client.screen.widget.GuiSlotScroll;
import es.degrassi.mmreborn.client.screen.widget.IGuiWrapper;
import es.degrassi.mmreborn.client.screen.widget.ISlotClickHandler;
import es.degrassi.mmreborn.client.screen.widget.tabs.AutoInputTabWidget;
import es.degrassi.mmreborn.client.screen.widget.tabs.AutoOutputTabWidget;
import es.degrassi.mmreborn.client.screen.widget.tabs.ITabGroupScreen;
import es.degrassi.mmreborn.client.screen.widget.tabs.TabGroupWidget;
import es.degrassi.mmreborn.client.util.GuiUtils;
import es.degrassi.mmreborn.common.entity.ItemInputBusEntity;
import es.degrassi.mmreborn.common.entity.ItemOutputBusEntity;
import es.degrassi.mmreborn.common.entity.base.TileItemBus;
import es.degrassi.mmreborn.common.util.TextureSizeHelper;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.event.ContainerScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;

public class ItemBusScreen
extends BaseScreen<ItemBusContainer, TileItemBus>
implements IGuiWrapper,
ITabGroupScreen {
    private static final int MAX_VISIBLE_ROWS = 5;
    private int visibleRows;
    private long lastMSInitialized;
    private boolean needsScrolling;
    public static int maxZOffset;
    private TabGroupWidget tabs;

    public ItemBusScreen(ItemBusContainer pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, pTitle, false);
        this.calculateScrollingNeeds();
    }

    private void calculateScrollingNeeds() {
        Font font = Minecraft.getInstance().font;
        int cols = ((TileItemBus)((ItemBusContainer)this.getMenu()).getEntity()).getSize().cols;
        int totalSlots = ((TileItemBus)((ItemBusContainer)this.getMenu()).getEntity()).getSlots();
        int totalRows = (int)Math.ceil((double)totalSlots * 1.0 / (double)cols);
        int slotsWidth = cols * 18 + 16;
        this.needsScrolling = totalRows > 5;
        this.visibleRows = Math.min(totalRows, 5);
        int slotsHeight = this.visibleRows * 18;
        int invWidth = 178 + ItemBusScreen.getScrollbarBackgroundWidth() + 8;
        this.imageHeight = slotsHeight + 10 + 72 + 3 + font.wordWrapHeight((FormattedText)this.title, Math.max(slotsWidth, invWidth) - 16) + this.titleLabelY;
        this.imageWidth = cols * 18 + 16 + ItemBusScreen.getScrollbarBackgroundWidth() * 2 + this.titleLabelX;
    }

    protected void containerTick() {
        super.containerTick();
        for (GuiEventListener child : this.children()) {
            if (!(child instanceof GuiElement)) continue;
            GuiElement element = (GuiElement)child;
            element.tick();
        }
    }

    @Override
    public long getTimeOpened() {
        return this.lastMSInitialized;
    }

    protected void init() {
        super.init();
        this.lastMSInitialized = Util.getMillis();
        GuiSlotScroll scroll = (GuiSlotScroll)this.addRenderableWidget((GuiEventListener)new GuiSlotScroll(this, this.titleLabelX, this.titleLabelY + 3, ((TileItemBus)((ItemBusContainer)this.getMenu()).getEntity()).getSize().cols, 5, ((ItemBusContainer)this.getMenu())::getItemList, (ISlotClickHandler)this.getMenu(), this.needsScrolling));
        scroll.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.tabs = TabGroupWidget.createLeft(this.getGuiLeft() - TextureSizeHelper.getWidth(AutoOutputTabWidget.TAB), this.getGuiTop());
        if (((TileItemBus)this.entity).getIoType().isInput()) {
            this.tabs.addTab(new AutoInputTabWidget<ItemInputBusEntity>((ItemInputBusEntity)this.entity));
        } else {
            this.tabs.addTab(new AutoOutputTabWidget<ItemOutputBusEntity>((ItemOutputBusEntity)this.entity));
        }
        this.addRenderableWidget((GuiEventListener)this.tabs);
    }

    @Override
    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ItemStack itemstack;
        int i = this.leftPos;
        int j = this.topPos;
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        NeoForge.EVENT_BUS.post((Event)new ContainerScreenEvent.Render.Background((AbstractContainerScreen)this, guiGraphics, mouseX, mouseY));
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        RenderSystem.disableDepthTest();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)i, (float)j, 0.0f);
        this.hoveredSlot = null;
        for (int k = 0; k < ((ItemBusContainer)this.menu).slots.size(); ++k) {
            Slot slot = (Slot)((ItemBusContainer)this.menu).slots.get(k);
            if (slot instanceof SlotItemComponent) continue;
            Slot copySlot = new Slot(slot.container, slot.getSlotIndex(), slot.x, slot.y);
            if (copySlot.isActive()) {
                this.renderSlot(guiGraphics, copySlot);
            }
            if (!this.isHovering(copySlot, mouseX, mouseY) || !copySlot.isActive()) continue;
            this.hoveredSlot = slot;
            this.renderSlotHighlight(guiGraphics, copySlot, mouseX, mouseY, partialTick);
        }
        this.renderLabels(guiGraphics, mouseX, mouseY);
        NeoForge.EVENT_BUS.post((Event)new ContainerScreenEvent.Render.Foreground((AbstractContainerScreen)this, guiGraphics, mouseX, mouseY));
        ItemStack itemStack = itemstack = this.draggingItem.isEmpty() ? ((ItemBusContainer)this.menu).getCarried() : this.draggingItem;
        if (!itemstack.isEmpty()) {
            int l1 = 8;
            int i2 = this.draggingItem.isEmpty() ? 8 : 16;
            String s = null;
            if (!this.draggingItem.isEmpty() && this.isSplittingStack) {
                itemstack = itemstack.copyWithCount(Mth.ceil((float)((float)itemstack.getCount() / 2.0f)));
            } else if (this.isQuickCrafting && this.quickCraftSlots.size() > 1 && (itemstack = itemstack.copyWithCount(this.quickCraftingRemainder)).isEmpty()) {
                s = String.valueOf(ChatFormatting.YELLOW) + "0";
            }
            this.renderFloatingItem(guiGraphics, itemstack, mouseX - i - 8, mouseY - j - i2, s);
        }
        if (!this.snapbackItem.isEmpty()) {
            float f = (float)(Util.getMillis() - this.snapbackTime) / 100.0f;
            if (f >= 1.0f) {
                f = 1.0f;
                this.snapbackItem = ItemStack.EMPTY;
            }
            int j2 = this.snapbackEnd.x - this.snapbackStartX;
            int k2 = this.snapbackEnd.y - this.snapbackStartY;
            int j1 = this.snapbackStartX + (int)((float)j2 * f);
            int k1 = this.snapbackStartY + (int)((float)k2 * f);
            this.renderFloatingItem(guiGraphics, this.snapbackItem, j1, k1, null);
        }
        guiGraphics.pose().popPose();
        RenderSystem.enableDepthTest();
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    @Override
    protected void renderBgWithSlotSize(GuiGraphics guiGraphics, int cols, int slots) {
        if (this.getTexture() != null) {
            guiGraphics.pose().pushPose();
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            int slotsWidth = cols * 18 + 16;
            int invWidth = 178 + ItemBusScreen.getScrollbarBackgroundWidth() + 8;
            int height = (int)Math.ceil((double)slots * 1.0 / (double)cols) * 18 + 10 + 72 + 3 + this.font.wordWrapHeight((FormattedText)this.title, Math.max(slotsWidth, invWidth) - 16) + this.titleLabelY;
            this.leftPos = (this.width - this.imageWidth) / 2;
            this.topPos = (this.height - this.imageHeight) / 2;
            guiGraphics.blitSprite(this.getTexture(), this.leftPos, this.topPos, Math.max(slotsWidth, invWidth), height);
            guiGraphics.pose().popPose();
        }
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        this.renderBgWithSlotSize(guiGraphics, ((TileItemBus)((ItemBusContainer)this.getMenu()).getEntity()).getSize().cols, this.visibleRows * ((TileItemBus)((ItemBusContainer)this.getMenu()).getEntity()).getSize().cols);
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int zOffset;
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        pose.translate(0.0f, 0.0f, 400.0f);
        for (GuiEventListener c : this.children()) {
            if (!(c instanceof GuiElement)) continue;
            GuiElement element = (GuiElement)c;
            element.onDrawBackground(guiGraphics, mouseX, mouseY, Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false));
        }
        this.drawForegroundText(guiGraphics, mouseX, mouseY);
        maxZOffset = zOffset = 200;
        for (GuiEventListener widget : this.children()) {
            if (!(widget instanceof GuiElement)) continue;
            GuiElement element = (GuiElement)widget;
            pose.pushPose();
            element.onRenderForeground(guiGraphics, mouseX, mouseY, zOffset, zOffset);
            pose.popPose();
        }
        pose.popPose();
        pose.translate(0.0f, 0.0f, (float)(maxZOffset += 200));
        pose.pushPose();
        pose.translate((float)(-this.leftPos), (float)(-this.topPos), 0.0f);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        pose.popPose();
    }

    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double xDelta, double yDelta) {
        return super.mouseScrolled(mouseX, mouseY, xDelta, yDelta);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.hasClicked = true;
        GuiEventListener clickedChild = GuiUtils.findChild(this.children(), mouseX, mouseY, button, GuiEventListener::mouseClicked);
        if (clickedChild != null) {
            this.setFocused(clickedChild);
            if (button == 0) {
                this.setDragging(true);
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }
        this.clearFocus();
        for (GuiEventListener element : this.children()) {
            TabGroupWidget widget;
            if (!(element instanceof TabGroupWidget) || !(widget = (TabGroupWidget)element).isMouseOver(mouseX, mouseY)) continue;
            widget.onClick(mouseX, mouseY, button);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.hasClicked) {
            return super.mouseReleased(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return GuiUtils.checkChildren(this.children(), keyCode, scanCode, modifiers, (child, k, s, m) -> child instanceof GuiElement && child.keyPressed(k, s, m)) || super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char c, int keyCode) {
        return GuiUtils.checkChildrenChar(this.children(), c, keyCode, (child, ch, k) -> child instanceof GuiElement && child.charTyped(ch, k)) || super.charTyped(c, keyCode);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double mouseXOld, double mouseYOld) {
        super.mouseDragged(mouseX, mouseY, button, mouseXOld, mouseYOld);
        return this.getFocused() != null && this.isDragging() && button == 0 && this.getFocused().mouseDragged(mouseX, mouseY, button, mouseXOld, mouseYOld);
    }

    public boolean isMouseOverSlot(Slot slot, double mouseX, double mouseY) {
        return this.isHovering(slot, mouseX, mouseY);
    }

    @Override
    @Generated
    public TabGroupWidget getTabs() {
        return this.tabs;
    }
}

