/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.screen;

import com.google.common.collect.Maps;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.client.ExperienceButtonType;
import es.degrassi.mmreborn.client.container.ExperienceHatchContainer;
import es.degrassi.mmreborn.client.screen.BaseScreen;
import es.degrassi.mmreborn.client.screen.widget.ExperienceButton;
import es.degrassi.mmreborn.client.screen.widget.ExperienceWidget;
import es.degrassi.mmreborn.client.screen.widget.GuiElement;
import es.degrassi.mmreborn.client.screen.widget.IGuiWrapper;
import es.degrassi.mmreborn.client.screen.widget.tabs.AutoInputTabWidget;
import es.degrassi.mmreborn.client.screen.widget.tabs.AutoOutputTabWidget;
import es.degrassi.mmreborn.client.screen.widget.tabs.ITabGroupScreen;
import es.degrassi.mmreborn.client.screen.widget.tabs.TabGroupWidget;
import es.degrassi.mmreborn.client.util.GuiUtils;
import es.degrassi.mmreborn.common.entity.ExperienceInputHatchEntity;
import es.degrassi.mmreborn.common.entity.ExperienceOutputHatchEntity;
import es.degrassi.mmreborn.common.entity.base.ExperienceHatchEntity;
import es.degrassi.mmreborn.common.network.client.CExperienceButtonClickedPacket;
import es.degrassi.mmreborn.common.util.TextureSizeHelper;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExperienceHatchScreen
extends BaseScreen<ExperienceHatchContainer, ExperienceHatchEntity>
implements IGuiWrapper,
ITabGroupScreen {
    private ExperienceWidget experienceWidget;
    private TabGroupWidget tabs;
    private final Map<ExperienceButtonType, ExperienceButton> experienceButtons = Maps.newEnumMap(ExperienceButtonType.class);

    public ExperienceHatchScreen(ExperienceHatchContainer menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title, false);
    }

    @Override
    @Nullable
    public ResourceLocation getTexture() {
        return ModularMachineryReborn.rl("textures/gui/guiexperience.png");
    }

    protected void init() {
        super.init();
        this.tabs = TabGroupWidget.createLeft(this.getGuiLeft() - TextureSizeHelper.getWidth(AutoOutputTabWidget.TAB), this.getGuiTop());
        if (((ExperienceHatchEntity)this.entity).getMode().isInput()) {
            this.tabs.addTab(new AutoInputTabWidget<ExperienceInputHatchEntity>((ExperienceInputHatchEntity)this.entity));
        } else {
            this.tabs.addTab(new AutoOutputTabWidget<ExperienceOutputHatchEntity>((ExperienceOutputHatchEntity)this.entity));
        }
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTick, mouseX, mouseY);
        this.clearWidgets();
        this.experienceWidget = (ExperienceWidget)this.addRenderableWidget((GuiEventListener)new ExperienceWidget(this.getGuiLeft(), this.getGuiTop() + 20, this.imageWidth, (ExperienceHatchEntity)((ExperienceHatchContainer)this.getMenu()).getEntity()));
        AtomicInteger x = new AtomicInteger(8 + this.getGuiLeft());
        Object object = ((ExperienceHatchContainer)this.getMenu()).getEntity();
        if (object instanceof ExperienceInputHatchEntity) {
            ExperienceInputHatchEntity e = (ExperienceInputHatchEntity)object;
            for (ExperienceButtonType type : ExperienceButtonType.insertions()) {
                this.experienceButtons.put(type, new ExperienceButton(x.getAndAdd(18), 45 + this.getGuiTop(), t -> PacketDistributor.sendToServer((CustomPacketPayload)new CExperienceButtonClickedPacket(e.getBlockPos(), t, t.extract()), (CustomPacketPayload[])new CustomPacketPayload[0]), type));
                this.addRenderableWidget((GuiEventListener)this.experienceButtons.get((Object)type));
            }
            x.getAndAdd(16);
        } else {
            object = ((ExperienceHatchContainer)this.getMenu()).getEntity();
            if (object instanceof ExperienceOutputHatchEntity) {
                ExperienceOutputHatchEntity e = (ExperienceOutputHatchEntity)object;
                x.set(this.getGuiLeft() + this.imageWidth - 8 - 17);
                for (ExperienceButtonType type : ExperienceButtonType.extractions().reversed()) {
                    this.experienceButtons.put(type, new ExperienceButton(x.getAndAdd(-18), 45 + this.getGuiTop(), t -> PacketDistributor.sendToServer((CustomPacketPayload)new CExperienceButtonClickedPacket(e.getBlockPos(), t, t.extract()), (CustomPacketPayload[])new CustomPacketPayload[0]), type));
                    this.addRenderableWidget((GuiEventListener)this.experienceButtons.get((Object)type));
                }
            }
        }
        if (this.tabs != null) {
            this.addRenderableWidget((GuiEventListener)this.tabs);
        }
        this.renderSlots(guiGraphics);
    }

    @Override
    protected void renderTooltip(@NotNull GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        if (this.experienceWidget.isHovered()) {
            guiGraphics.renderTooltip(this.font, this.experienceWidget.getTooltipMessage(), x, y);
        }
        for (ExperienceButton button : this.experienceButtons.values()) {
            if (!button.isHovered()) continue;
            guiGraphics.renderTooltip(this.font, button.getTooltipMessage().stream().map(Component::getVisualOrderText).toList(), x, y);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.hasClicked = true;
        GuiEventListener clickedChild = GuiUtils.findChild(this.children(), mouseX, mouseY, button, GuiEventListener::mouseClicked);
        if (clickedChild != null) {
            this.setFocused(clickedChild);
            if (button == 0) {
                this.setDragging(true);
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }
        this.clearFocus();
        for (GuiEventListener element : this.children()) {
            TabGroupWidget widget;
            if (!(element instanceof TabGroupWidget) || !(widget = (TabGroupWidget)element).isMouseOver(mouseX, mouseY)) continue;
            widget.onClick(mouseX, mouseY, button);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.hasClicked) {
            return super.mouseReleased(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return GuiUtils.checkChildren(this.children(), keyCode, scanCode, modifiers, (child, k, s, m) -> child instanceof GuiElement && child.keyPressed(k, s, m)) || super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char c, int keyCode) {
        return GuiUtils.checkChildrenChar(this.children(), c, keyCode, (child, ch, k) -> child instanceof GuiElement && child.charTyped(ch, k)) || super.charTyped(c, keyCode);
    }

    @Override
    @Generated
    public TabGroupWidget getTabs() {
        return this.tabs;
    }
}

