/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.screen;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.client.container.EnergyHatchContainer;
import es.degrassi.mmreborn.client.screen.BaseScreen;
import es.degrassi.mmreborn.client.screen.widget.GuiElement;
import es.degrassi.mmreborn.client.screen.widget.IGuiWrapper;
import es.degrassi.mmreborn.client.screen.widget.tabs.AutoInputTabWidget;
import es.degrassi.mmreborn.client.screen.widget.tabs.AutoOutputTabWidget;
import es.degrassi.mmreborn.client.screen.widget.tabs.ITabGroupScreen;
import es.degrassi.mmreborn.client.screen.widget.tabs.TabGroupWidget;
import es.degrassi.mmreborn.client.util.EnergyDisplayUtil;
import es.degrassi.mmreborn.client.util.GuiUtils;
import es.degrassi.mmreborn.common.entity.EnergyInputHatchEntity;
import es.degrassi.mmreborn.common.entity.EnergyOutputHatchEntity;
import es.degrassi.mmreborn.common.entity.base.EnergyHatchEntity;
import es.degrassi.mmreborn.common.util.TextureSizeHelper;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class EnergyHatchScreen
extends BaseScreen<EnergyHatchContainer, EnergyHatchEntity>
implements IGuiWrapper,
ITabGroupScreen {
    private TabGroupWidget tabs;

    public EnergyHatchScreen(EnergyHatchContainer pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, pTitle, false);
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
    }

    protected void init() {
        super.init();
        this.tabs = TabGroupWidget.createLeft(this.getGuiLeft() - TextureSizeHelper.getWidth(AutoOutputTabWidget.TAB), this.getGuiTop());
        if (((EnergyHatchEntity)this.entity).getMode().isInput()) {
            this.tabs.addTab(new AutoInputTabWidget<EnergyInputHatchEntity>((EnergyInputHatchEntity)this.entity));
        } else {
            this.tabs.addTab(new AutoOutputTabWidget<EnergyOutputHatchEntity>((EnergyOutputHatchEntity)this.entity));
        }
        this.addRenderableWidget((GuiEventListener)this.tabs);
    }

    @Override
    public ResourceLocation getTexture() {
        return ModularMachineryReborn.rl("textures/gui/guibar.png");
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTick, mouseX, mouseY);
        guiGraphics.pose().pushPose();
        float percFilled = (float)((EnergyHatchEntity)this.entity).getCurrentEnergy() / (float)((EnergyHatchEntity)this.entity).getMaxEnergy();
        int pxFilled = Mth.ceil((float)(percFilled * 61.0f));
        guiGraphics.blit(this.getTexture(), this.leftPos + 15, this.topPos + 10 + 61 - pxFilled, 196, 61 - pxFilled, 20, pxFilled);
        guiGraphics.pose().popPose();
        this.renderSlots(guiGraphics);
    }

    @Override
    protected void renderTooltip(@NotNull GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        int offsetX = (this.width - this.getXSize()) / 2;
        int offsetZ = (this.height - this.getYSize()) / 2;
        if (x >= 15 + offsetX && x <= 35 + offsetX && y >= 10 + offsetZ && y <= 71 + offsetZ) {
            long currentEnergy = EnergyDisplayUtil.type.formatEnergyForDisplay(((EnergyHatchEntity)this.entity).getCurrentEnergy());
            long maxEnergy = EnergyDisplayUtil.type.formatEnergyForDisplay(((EnergyHatchEntity)this.entity).getMaxEnergy());
            MutableComponent text = Component.translatable((String)"tooltip.energyhatch.charge", (Object[])new Object[]{String.valueOf(currentEnergy), String.valueOf(maxEnergy), Component.translatable((String)EnergyDisplayUtil.type.getUnlocalizedFormat())});
            Font font = Minecraft.getInstance().font;
            guiGraphics.renderTooltip(font, (Component)text, x, y);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.hasClicked = true;
        GuiEventListener clickedChild = GuiUtils.findChild(this.children(), mouseX, mouseY, button, GuiEventListener::mouseClicked);
        if (clickedChild != null) {
            this.setFocused(clickedChild);
            if (button == 0) {
                this.setDragging(true);
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }
        this.clearFocus();
        for (GuiEventListener element : this.children()) {
            TabGroupWidget widget;
            if (!(element instanceof TabGroupWidget) || !(widget = (TabGroupWidget)element).isMouseOver(mouseX, mouseY)) continue;
            widget.onClick(mouseX, mouseY, button);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.hasClicked) {
            return super.mouseReleased(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return GuiUtils.checkChildren(this.children(), keyCode, scanCode, modifiers, (child, k, s, m) -> child instanceof GuiElement && child.keyPressed(k, s, m)) || super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char c, int keyCode) {
        return GuiUtils.checkChildrenChar(this.children(), c, keyCode, (child, ch, k) -> child instanceof GuiElement && child.charTyped(ch, k)) || super.charTyped(c, keyCode);
    }

    @Override
    @Generated
    public TabGroupWidget getTabs() {
        return this.tabs;
    }
}

