/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.client.container.ContainerBase;
import es.degrassi.mmreborn.client.screen.widget.GuiElement;
import es.degrassi.mmreborn.client.screen.widget.IGuiWrapper;
import es.degrassi.mmreborn.client.screen.widget.tabs.TabGroupWidget;
import es.degrassi.mmreborn.common.entity.base.ColorableMachineComponentEntity;
import es.degrassi.mmreborn.common.util.TextureSizeHelper;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.event.ContainerScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;

public abstract class BaseScreen<T extends ContainerBase<E>, E extends ColorableMachineComponentEntity>
extends AbstractContainerScreen<T>
implements IGuiWrapper {
    public static final ResourceLocation BASE_SLOT = ModularMachineryReborn.rl("textures/gui/base_slot.png");
    public static final ResourceLocation BASE_SLOT_HOVERED = ModularMachineryReborn.rl("textures/gui/base_slot_hovered.png");
    public static final ResourceLocation TAB = ModularMachineryReborn.rl("textures/gui/widget/base_tab_top.png");
    public static final ResourceLocation TAB_HOVERED = ModularMachineryReborn.rl("textures/gui/widget/base_tab_hovered_top.png");
    public static final ResourceLocation SCROLLBAR_BACKGROUND = ModularMachineryReborn.rl("small_scroller_disabled");
    public static final ResourceLocation SCROLLBAR_THUMB = ModularMachineryReborn.rl("small_scroller");
    public static final int SLOT_SIZE = 18;
    protected boolean hasClicked = false;
    protected final E entity;
    protected final boolean shouldRenderLabels;

    protected BaseScreen(T menu, Inventory playerInventory, Component title, boolean renderLabels) {
        super(menu, playerInventory, title);
        this.entity = ((ContainerBase)((Object)menu)).getEntity();
        this.shouldRenderLabels = renderLabels;
    }

    @Override
    public ItemStack getCarriedItem() {
        return ((ContainerBase)this.getMenu()).getCarried();
    }

    @Override
    @Nullable
    public BaseScreen<?, ?> getWindowHovering(double mouseX, double mouseY) {
        if (mouseX >= (double)this.getGuiLeft() && mouseX <= (double)(this.getGuiLeft() + this.imageWidth) && mouseY >= (double)this.getGuiTop() && mouseY <= (double)(this.getGuiTop() + this.imageHeight) || this.children().stream().anyMatch(child -> child.isMouseOver(mouseX, mouseY))) {
            return this;
        }
        return null;
    }

    @Override
    public void renderSlotHighlight(GuiGraphics guiGraphics, Slot slot, int mouseX, int mouseY, float partialTick) {
        this.renderSlotHighlight(guiGraphics, slot, mouseX, mouseY, partialTick, 0);
    }

    @Nullable
    public ResourceLocation getTexture() {
        return ModularMachineryReborn.rl("background");
    }

    public static ResourceLocation getScrollbarBackground() {
        return SCROLLBAR_BACKGROUND;
    }

    public static ResourceLocation getScrollbarThumb() {
        return SCROLLBAR_THUMB;
    }

    public static int getScrollbarBackgroundWidth() {
        return TextureSizeHelper.getWidth(ModularMachineryReborn.rl("textures/gui/sprites/" + BaseScreen.getScrollbarBackground().getPath()));
    }

    public static int getScrollbarBackgroundHeight() {
        return TextureSizeHelper.getHeight(ModularMachineryReborn.rl("textures/gui/sprites/" + BaseScreen.getScrollbarBackground().getPath()));
    }

    public static int getScrollbarWidth() {
        return TextureSizeHelper.getWidth(ModularMachineryReborn.rl("textures/gui/sprites/" + BaseScreen.getScrollbarThumb().getPath()));
    }

    public static int getScrollbarHeight() {
        return TextureSizeHelper.getHeight(ModularMachineryReborn.rl("textures/gui/sprites/" + BaseScreen.getScrollbarThumb().getPath()));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ItemStack itemstack;
        int i = this.leftPos;
        int j = this.topPos;
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        NeoForge.EVENT_BUS.post((Event)new ContainerScreenEvent.Render.Background((AbstractContainerScreen)this, guiGraphics, mouseX, mouseY));
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        RenderSystem.disableDepthTest();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)i, (float)j, 0.0f);
        this.hoveredSlot = null;
        for (int k = 0; k < ((ContainerBase)this.menu).slots.size(); ++k) {
            Slot slot = (Slot)((ContainerBase)this.menu).slots.get(k);
            if (!slot.isActive()) continue;
            this.renderSlot(guiGraphics, slot);
            if (!this.isHovering(slot, mouseX, mouseY)) continue;
            this.hoveredSlot = slot;
            this.renderSlotHighlight(guiGraphics, slot, mouseX, mouseY, partialTick);
        }
        this.renderLabels(guiGraphics, mouseX, mouseY);
        NeoForge.EVENT_BUS.post((Event)new ContainerScreenEvent.Render.Foreground((AbstractContainerScreen)this, guiGraphics, mouseX, mouseY));
        ItemStack itemStack = itemstack = this.draggingItem.isEmpty() ? ((ContainerBase)this.menu).getCarried() : this.draggingItem;
        if (!itemstack.isEmpty()) {
            int l1 = 8;
            int i2 = this.draggingItem.isEmpty() ? 8 : 16;
            String s = null;
            if (!this.draggingItem.isEmpty() && this.isSplittingStack) {
                itemstack = itemstack.copyWithCount(Mth.ceil((float)((float)itemstack.getCount() / 2.0f)));
            } else if (this.isQuickCrafting && this.quickCraftSlots.size() > 1 && (itemstack = itemstack.copyWithCount(this.quickCraftingRemainder)).isEmpty()) {
                s = String.valueOf(ChatFormatting.YELLOW) + "0";
            }
            this.renderFloatingItem(guiGraphics, itemstack, mouseX - i - 8, mouseY - j - i2, s);
        }
        if (!this.snapbackItem.isEmpty()) {
            float f = (float)(Util.getMillis() - this.snapbackTime) / 100.0f;
            if (f >= 1.0f) {
                f = 1.0f;
                this.snapbackItem = ItemStack.EMPTY;
            }
            int j2 = this.snapbackEnd.x - this.snapbackStartX;
            int k2 = this.snapbackEnd.y - this.snapbackStartY;
            int j1 = this.snapbackStartX + (int)((float)j2 * f);
            int k1 = this.snapbackStartY + (int)((float)k2 * f);
            this.renderFloatingItem(guiGraphics, this.snapbackItem, j1, k1, null);
        }
        guiGraphics.pose().popPose();
        RenderSystem.enableDepthTest();
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    public void renderSlot(GuiGraphics guiGraphics, Slot slot) {
        guiGraphics.blit(BASE_SLOT, slot.x - 1, slot.y - 1, 0.0f, 0.0f, 18, 18, TextureSizeHelper.getWidth(BASE_SLOT), TextureSizeHelper.getHeight(BASE_SLOT));
        super.renderSlot(guiGraphics, slot);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.shouldRenderLabels) {
            super.renderLabels(guiGraphics, mouseX, mouseY);
        }
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        for (GuiEventListener element : this.children()) {
            if (!(element instanceof TabGroupWidget)) continue;
            TabGroupWidget widget = (TabGroupWidget)element;
            widget.renderTooltip(guiGraphics, x, y);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        if (this.getTexture() != null) {
            guiGraphics.pose().pushPose();
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            this.leftPos = (this.width - this.imageWidth) / 2;
            this.topPos = (this.height - this.imageHeight) / 2;
            guiGraphics.blit(this.getTexture(), this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
            guiGraphics.pose().popPose();
        }
    }

    protected void renderBgWithSlotSize(GuiGraphics guiGraphics, int cols, int slots) {
        if (this.getTexture() != null) {
            guiGraphics.pose().pushPose();
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            this.leftPos = (this.width - this.imageWidth) / 2;
            this.topPos = (this.height - this.imageHeight) / 2;
            int slotsWidth = cols * 18 + 16;
            int invWidth = 178;
            int height = (int)Math.ceil((double)slots * 1.0 / (double)cols) * 18 + 16 + 72 + 3 + this.font.wordWrapHeight((FormattedText)this.title, Math.max(slotsWidth, invWidth) - 16) + this.titleLabelY;
            guiGraphics.blitSprite(this.getTexture(), this.leftPos, this.topPos, Math.max(slotsWidth, invWidth), height);
            guiGraphics.pose().popPose();
        }
    }

    protected void renderSlots(GuiGraphics guiGraphics) {
        for (Slot slot : ((ContainerBase)this.getMenu()).slots) {
            guiGraphics.blit(BASE_SLOT, slot.x + this.getGuiLeft() - 1, slot.y + this.getGuiTop() - 1, 0.0f, 0.0f, TextureSizeHelper.getWidth(BASE_SLOT), TextureSizeHelper.getHeight(BASE_SLOT), TextureSizeHelper.getWidth(BASE_SLOT), TextureSizeHelper.getHeight(BASE_SLOT));
        }
    }

    public static void renderSlotHighlight(GuiGraphics guiGraphics, int x, int y, int color, int z) {
        guiGraphics.pose().pushPose();
        int width = TextureSizeHelper.getWidth(BASE_SLOT_HOVERED);
        int height = TextureSizeHelper.getHeight(BASE_SLOT_HOVERED);
        guiGraphics.blit(BASE_SLOT_HOVERED, x - 1, y - 1, 0.0f, 0.0f, width, height, width, height);
        guiGraphics.fillGradient(RenderType.guiOverlay(), x, y, x + 16, y + 16, color, color, z);
        guiGraphics.pose().popPose();
    }

    public void setHoveredSlot(Slot slot) {
        this.hoveredSlot = slot;
    }

    public boolean childrenContainsElement(Predicate<GuiElement> predicate) {
        return this.children().stream().filter(el -> el instanceof GuiElement).map(el -> (GuiElement)el).anyMatch(predicate);
    }

    @Override
    public int getSlotColor() {
        return this.slotColor;
    }
}

