/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.model.casing;

import java.util.Arrays;
import java.util.Objects;
import net.minecraft.core.Direction;

public final class CasingState {
    public static final CasingState DEFAULT;
    private final int[] masks;
    private final boolean[] adjacentCasingBlocks;

    public CasingState(int[] masks, boolean[] adjacentCasingBlocks) {
        this.adjacentCasingBlocks = (boolean[])adjacentCasingBlocks.clone();
        this.masks = (int[])masks.clone();
    }

    public int getMask(Direction side) {
        return this.masks[side.get3DDataValue()];
    }

    public boolean hasAdjacentCasingBlock(Direction side) {
        return this.adjacentCasingBlocks[side.get3DDataValue()];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CasingState)) {
            return false;
        }
        CasingState that = (CasingState)o;
        return Arrays.equals(this.masks, that.masks) && Arrays.equals(this.adjacentCasingBlocks, that.adjacentCasingBlocks);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.masks), Arrays.hashCode(this.adjacentCasingBlocks));
    }

    static {
        int[] masks = new int[6];
        Arrays.fill(masks, 15);
        boolean[] adjacentCasingBlocks = new boolean[6];
        DEFAULT = new CasingState(masks, adjacentCasingBlocks);
    }
}

