/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.item;

import es.degrassi.mmreborn.common.util.CycleTimer;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;

public class MMRItemTooltipComponent
implements TooltipComponent {
    private final List<ItemStack> item;
    private Component component = Component.empty();
    private final CycleTimer timer;

    public MMRItemTooltipComponent(List<ItemStack> stack, CycleTimer timer) {
        this.item = stack;
        this.timer = timer;
    }

    public boolean isCompleted() {
        Inventory inv = Minecraft.getInstance().player.getInventory();
        List<ItemStack> invStacks = inv.items.stream().filter(stack -> !stack.isEmpty()).collect(Collectors.groupingBy(ItemStack::getItemHolder, Collectors.summingInt(ItemStack::getCount))).entrySet().stream().map(entry -> new ItemStack((Holder)entry.getKey(), ((Integer)entry.getValue()).intValue())).toList();
        for (ItemStack invStack : invStacks) {
            for (ItemStack stack2 : this.item) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)stack2, (ItemStack)invStack) || invStack.getCount() < stack2.getCount()) continue;
                return true;
            }
        }
        return false;
    }

    public ItemStack getItem() {
        return this.timer.getOrDefault(this.item, ItemStack.EMPTY);
    }

    @Generated
    public Component getComponent() {
        return this.component;
    }

    @Generated
    public CycleTimer getTimer() {
        return this.timer;
    }

    @Generated
    public void setComponent(Component component) {
        this.component = component;
    }
}

