/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.integration.emi;

import com.google.common.collect.Lists;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import es.degrassi.mmreborn.api.TagUtil;
import es.degrassi.mmreborn.api.crafting.requirement.RecipeRequirement;
import es.degrassi.mmreborn.api.integration.emi.RegisterEmiComponentEvent;
import es.degrassi.mmreborn.api.integration.emi.RegisterEmiEmptyRequirementEvent;
import es.degrassi.mmreborn.api.integration.emi.RegisterEmiRequirementToIngredientEvent;
import es.degrassi.mmreborn.api.integration.emi.RegisterEmiRequirementToStackEvent;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementDurability;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementDurabilityPerTick;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementFluid;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementFluidPerTick;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementItem;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementLootTable;
import es.degrassi.mmreborn.common.crafting.requirement.emi.EmiDurabilityComponent;
import es.degrassi.mmreborn.common.crafting.requirement.emi.EmiDurabilityPerTickComponent;
import es.degrassi.mmreborn.common.crafting.requirement.emi.EmiEmptyComponent;
import es.degrassi.mmreborn.common.crafting.requirement.emi.EmiEnergyComponent;
import es.degrassi.mmreborn.common.crafting.requirement.emi.EmiEnergyPerTickComponent;
import es.degrassi.mmreborn.common.crafting.requirement.emi.EmiFluidComponent;
import es.degrassi.mmreborn.common.crafting.requirement.emi.EmiFluidPerTickComponent;
import es.degrassi.mmreborn.common.crafting.requirement.emi.EmiFuelComponent;
import es.degrassi.mmreborn.common.crafting.requirement.emi.EmiItemComponent;
import es.degrassi.mmreborn.common.crafting.requirement.emi.EmiLootTableComponent;
import es.degrassi.mmreborn.common.integration.emi.EmiComponentRegistry;
import es.degrassi.mmreborn.common.integration.emi.EmiEmptyRequirementRegistry;
import es.degrassi.mmreborn.common.integration.emi.EmiIngredientRegistry;
import es.degrassi.mmreborn.common.integration.emi.EmiStackRegistry;
import es.degrassi.mmreborn.common.machine.component.DurabilityComponent;
import es.degrassi.mmreborn.common.machine.component.ItemComponent;
import es.degrassi.mmreborn.common.registration.EmptyRequirementTypeRegistration;
import es.degrassi.mmreborn.common.registration.RequirementTypeRegistration;
import es.degrassi.mmreborn.common.util.IOInventory;
import es.degrassi.mmreborn.common.util.LootTableHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;

public class MMREmiClientIntegration {
    public MMREmiClientIntegration(IEventBus bus) {
        bus.register((Object)this);
        EmiComponentRegistry.init();
        EmiStackRegistry.init();
        EmiIngredientRegistry.init();
        EmiEmptyRequirementRegistry.init();
    }

    @SubscribeEvent
    public void registerEmiEmptyRequirement(RegisterEmiEmptyRequirementEvent event) {
        event.register(EmptyRequirementTypeRegistration.ITEM.get(), (component, widgets, recipe) -> widgets.add((Widget)component));
        event.register(EmptyRequirementTypeRegistration.FLUID.get(), (component, widgets, recipe) -> widgets.add((Widget)component));
        event.register(EmptyRequirementTypeRegistration.ENERGY.get(), (component, widgets, recipe) -> widgets.add((Widget)component));
    }

    @SubscribeEvent
    public void registerEmiComponents(RegisterEmiComponentEvent event) {
        event.register(RequirementTypeRegistration.ENERGY.get(), EmiEnergyComponent::new);
        event.register(RequirementTypeRegistration.ENERGY_PER_TICK.get(), EmiEnergyPerTickComponent::new);
        event.register(RequirementTypeRegistration.ITEM.get(), EmiItemComponent::new);
        event.register(RequirementTypeRegistration.DURABILITY.get(), EmiDurabilityComponent::new);
        event.register(RequirementTypeRegistration.DURABILITY_PER_TICK.get(), EmiDurabilityPerTickComponent::new);
        event.register(RequirementTypeRegistration.FLUID.get(), EmiFluidComponent::new);
        event.register(RequirementTypeRegistration.FLUID_PER_TICK.get(), EmiFluidPerTickComponent::new);
        event.register(RequirementTypeRegistration.LOOT_TABLE.get(), EmiLootTableComponent::new);
        event.register(RequirementTypeRegistration.FUEL.get(), EmiFuelComponent::new);
        event.register(RequirementTypeRegistration.EMPTY.get(), EmiEmptyComponent::new);
    }

    @SubscribeEvent
    public void registerEmiStacks(RegisterEmiRequirementToStackEvent event) {
        event.register(RequirementTypeRegistration.ITEM.get(), this::emiStackFromItemRequirement);
        event.register(RequirementTypeRegistration.DURABILITY.get(), this::emiStackFromDurabilityRequirement);
        event.register(RequirementTypeRegistration.DURABILITY_PER_TICK.get(), this::emiStackFromDurabilityPerTickRequirement);
        event.register(RequirementTypeRegistration.FLUID.get(), requirement -> Arrays.stream(((RequirementFluid)requirement.requirement()).getIngredient().ingredient().getStacks()).map(stack -> EmiStack.of((Fluid)stack.getFluid(), (long)((RequirementFluid)requirement.requirement()).getIngredient().amount())).toList());
        event.register(RequirementTypeRegistration.FLUID_PER_TICK.get(), requirement -> Arrays.stream(((RequirementFluidPerTick)requirement.requirement()).getIngredient().ingredient().getStacks()).map(stack -> EmiStack.of((Fluid)stack.getFluid(), (long)((RequirementFluidPerTick)requirement.requirement()).getIngredient().amount())).toList());
        event.register(RequirementTypeRegistration.LOOT_TABLE.get(), requirement -> LootTableHelper.getLootsForTable(((RequirementLootTable)requirement.requirement()).getLootTable()).stream().map(LootTableHelper.LootData::stack).map(EmiStack::of).toList());
    }

    @SubscribeEvent
    public void registerEmiIngredients(RegisterEmiRequirementToIngredientEvent event) {
        event.register(RequirementTypeRegistration.ITEM.get(), this::emiIngredientFromItemRequirement);
        event.register(RequirementTypeRegistration.DURABILITY.get(), this::emiIngredientFromDurabilityRequirement);
        event.register(RequirementTypeRegistration.DURABILITY_PER_TICK.get(), this::emiIngredientFromDurabilityPerTickRequirement);
    }

    private EmiIngredient emiIngredientFromItemRequirement(RecipeRequirement<ItemComponent, RequirementItem, IOInventory> requirement) {
        return EmiIngredient.of((Ingredient)requirement.requirement().ingredient.ingredient(), (long)requirement.requirement().ingredient.count());
    }

    private EmiIngredient emiIngredientFromDurabilityRequirement(RecipeRequirement<DurabilityComponent, RequirementDurability, IOInventory> requirement) {
        return EmiIngredient.of((Ingredient)this.ingredientFromDurabilityRequirement(requirement.requirement().ingredient), (long)requirement.requirement().getAmount());
    }

    private EmiIngredient emiIngredientFromDurabilityPerTickRequirement(RecipeRequirement<DurabilityComponent, RequirementDurabilityPerTick, IOInventory> requirement) {
        return EmiIngredient.of((Ingredient)this.ingredientFromDurabilityRequirement(requirement.requirement().ingredient), (long)requirement.requirement().getAmount());
    }

    private Ingredient ingredientFromDurabilityRequirement(Ingredient original) {
        List items = ((Stream)Arrays.stream(original.getItems()).map(this::generateWithDurability).flatMap(Collection::stream).unordered()).toList();
        return Ingredient.of(items.stream());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<EmiStack> emiStackFromItemRequirement(RecipeRequirement<ItemComponent, RequirementItem, IOInventory> requirement) {
        ArrayList stacks = Lists.newArrayList();
        Ingredient.Value[] valueArray = requirement.requirement().getIngredient().ingredient().values;
        int n = valueArray.length;
        int n2 = 0;
        while (n2 < n) {
            Ingredient.Value value = valueArray[n2];
            if (value instanceof Ingredient.TagValue) {
                Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
                try {
                    object = tagValue.tag();
                    TagKey tag = object;
                    object = TagUtil.getItems((TagKey<Item>)tag).toList().iterator();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                while (object.hasNext()) {
                    Item stack = (Item)object.next();
                    stacks.add(EmiStack.of((ItemStack)new ItemStack((ItemLike)stack, requirement.requirement().ingredient.count()), (long)requirement.requirement().ingredient.count()));
                }
            } else if (value instanceof Ingredient.ItemValue) {
                Ingredient.ItemValue itemValue = (Ingredient.ItemValue)value;
                {
                    object = itemValue.item();
                    TagKey item = object;
                    stacks.add(EmiStack.of((ItemStack)item.copyWithCount(requirement.requirement().ingredient.count()), (long)requirement.requirement().ingredient.count()));
                }
            }
            ++n2;
        }
        return stacks;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<EmiStack> emiStackFromDurabilityRequirement(RecipeRequirement<DurabilityComponent, RequirementDurability, IOInventory> requirement) {
        ArrayList stacks = Lists.newArrayList();
        Ingredient.Value[] valueArray = requirement.requirement().getIngredient().values;
        int n = valueArray.length;
        int n2 = 0;
        while (n2 < n) {
            Ingredient.Value value = valueArray[n2];
            if (value instanceof Ingredient.TagValue) {
                Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
                try {
                    object = tagValue.tag();
                    TagKey tag = object;
                    object = TagUtil.getItems((TagKey<Item>)tag).toList().iterator();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                while (object.hasNext()) {
                    Item stack = (Item)object.next();
                    stacks.addAll(this.generateWithDurability(new ItemStack((ItemLike)stack), requirement.requirement().getAmount()));
                }
            } else if (value instanceof Ingredient.ItemValue) {
                Ingredient.ItemValue itemValue = (Ingredient.ItemValue)value;
                {
                    object = itemValue.item();
                    TagKey item = object;
                    stacks.addAll(this.generateWithDurability((ItemStack)item, requirement.requirement().getAmount()));
                }
            }
            ++n2;
        }
        return ((Stream)stacks.stream().unordered()).toList();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<EmiStack> emiStackFromDurabilityPerTickRequirement(RecipeRequirement<DurabilityComponent, RequirementDurabilityPerTick, IOInventory> requirement) {
        ArrayList stacks = Lists.newArrayList();
        Ingredient.Value[] valueArray = requirement.requirement().getIngredient().values;
        int n = valueArray.length;
        int n2 = 0;
        while (n2 < n) {
            Ingredient.Value value = valueArray[n2];
            if (value instanceof Ingredient.TagValue) {
                Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
                try {
                    object = tagValue.tag();
                    TagKey tag = object;
                    object = TagUtil.getItems((TagKey<Item>)tag).toList().iterator();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                while (object.hasNext()) {
                    Item stack = (Item)object.next();
                    stacks.addAll(this.generateWithDurability(new ItemStack((ItemLike)stack), requirement.requirement().getAmount()));
                }
            } else if (value instanceof Ingredient.ItemValue) {
                Ingredient.ItemValue itemValue = (Ingredient.ItemValue)value;
                {
                    object = itemValue.item();
                    TagKey item = object;
                    stacks.addAll(this.generateWithDurability((ItemStack)item, requirement.requirement().getAmount()));
                }
            }
            ++n2;
        }
        return ((Stream)stacks.stream().unordered()).toList();
    }

    private List<ItemStack> generateWithDurability(ItemStack stack) {
        if (!stack.isDamageableItem()) {
            throw new IllegalArgumentException(String.format("Invalid Item given in durability requirement, is not damageable: %s", stack.getDisplayName().getString()));
        }
        int maxDamage = stack.getMaxDamage();
        ArrayList damagedItems = Lists.newArrayList();
        for (int i = 0; i <= maxDamage; ++i) {
            ItemStack copy = stack.copy();
            copy.setDamageValue(i);
            damagedItems.add(copy);
        }
        return ((Stream)damagedItems.stream().unordered()).toList();
    }

    private List<EmiStack> generateWithDurability(ItemStack stack, int amount) {
        return this.generateWithDurability(stack).stream().map(s -> EmiStack.of((ItemStack)s, (long)amount)).toList();
    }
}

