/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.integration.athena.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import earth.terrarium.athena.api.client.models.TintProvider;
import earth.terrarium.athena.api.client.utils.AppearanceAndTintGetter;
import earth.terrarium.athena.api.client.utils.AthenaUtils;
import earth.terrarium.athena.api.client.utils.CtmState;
import earth.terrarium.athena.impl.client.models.ctm.ConnectedTextureMap;
import es.degrassi.mmreborn.client.integration.athena.utils.MMRAthenaBlockElementFace;
import es.degrassi.mmreborn.client.integration.athena.utils.MMRAthenaQuad;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.geometry.UnbakedGeometryHelper;
import org.joml.Vector3f;

public class CtmUtils {
    private static final BiPredicate<BlockState, BlockState> FALSE = (selfState, otherState) -> false;
    private static final BiPredicate<BlockState, BlockState> STATE = (selfState, otherState) -> selfState == otherState;
    private static final BiPredicate<BlockState, BlockState> IS = (selfState, otherState) -> selfState.is(otherState.getBlock());

    public static int getTexture(boolean first, boolean second, boolean firstSecond) {
        if (first && second) {
            return firstSecond ? 1 : 2;
        }
        return first ? 3 : (second ? 4 : 0);
    }

    public static int getTexture(boolean first, boolean second, boolean firstSecond, int offset) {
        int texture = CtmUtils.getTexture(first, second, firstSecond);
        if (offset == 0 || texture == 1) {
            return texture;
        }
        if (texture == 0) {
            return 6;
        }
        return texture + offset;
    }

    public static Int2ObjectMap<Material> parseCtmMaterials(JsonObject json) {
        Int2ObjectArrayMap materials = new Int2ObjectArrayMap();
        materials.put(0, (Object)CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)"particle")));
        materials.put(1, (Object)CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)"empty")));
        materials.put(2, (Object)CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)"center")));
        materials.put(3, (Object)CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)"vertical")));
        materials.put(4, (Object)CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)"horizontal")));
        if (json.has("overlay")) {
            materials.put(5, (Object)CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)"overlay")));
        }
        if (json.has("ov_particle")) {
            materials.put(6, (Object)CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)"ov_particle")));
        }
        if (json.has("ov_center")) {
            materials.put(7, (Object)CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)"ov_center")));
        }
        if (json.has("ov_vertical")) {
            materials.put(8, (Object)CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)"ov_vertical")));
        }
        if (json.has("ov_horizontal")) {
            materials.put(9, (Object)CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)"ov_horizontal")));
        }
        return materials;
    }

    public static Material blockMat(String id) {
        return new Material(InventoryMenu.BLOCK_ATLAS, ResourceLocation.parse((String)id));
    }

    public static <I, O> O tryParse(I input, Function<I, O> parser) {
        try {
            return parser.apply(input);
        }
        catch (Exception var3) {
            return null;
        }
    }

    public static Rotation getPillarRotation(Direction.Axis axis, Direction direction) {
        if (axis != Direction.Axis.X) {
            if (axis == Direction.Axis.Z) {
                return direction.getAxis().isVertical() ? (Rotation)AthenaUtils.ternary((Direction.AxisDirection)direction.getAxisDirection(), (Object)Rotation.NONE, (Object)Rotation.CLOCKWISE_180) : (Rotation)AthenaUtils.ternary((Direction.AxisDirection)direction.getAxisDirection(), (Object)Rotation.CLOCKWISE_90, (Object)Rotation.COUNTERCLOCKWISE_90);
            }
            return Rotation.NONE;
        }
        return direction.getAxis().isHorizontal() && !AthenaUtils.asBool((Direction.AxisDirection)direction.getAxisDirection()) ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90;
    }

    public static BiPredicate<BlockState, BlockState> parseCondition(JsonObject json) {
        if (!json.has("connect_to")) {
            return STATE;
        }
        JsonElement var2 = json.get("connect_to");
        if (var2 instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)var2;
            return CtmUtils.parseConditionInternal(jsonObject);
        }
        return FALSE;
    }

    private static BiPredicate<BlockState, BlockState> parseConditionInternal(JsonObject json) {
        return switch (GsonHelper.getAsString((JsonObject)json, (String)"type", (String)"")) {
            case "not" -> CtmUtils.parseNotCondition(json);
            case "and" -> CtmUtils.parseListCondition(json, BiPredicate::and);
            case "or" -> CtmUtils.parseListCondition(json, BiPredicate::or);
            case "xor" -> CtmUtils.parseXorCondition(json);
            case "state" -> CtmUtils.parseStateCondition(json);
            case "tag" -> CtmUtils.parseTagCondition(json);
            case "sameBlock" -> IS;
            case "sameState" -> STATE;
            default -> FALSE;
        };
    }

    private static BiPredicate<BlockState, BlockState> parseListCondition(JsonObject json, BinaryOperator<BiPredicate<BlockState, BlockState>> mapper) {
        List<BiPredicate> conditions = CtmUtils.unwrapConditions(json).stream().map(CtmUtils::parseConditionInternal).toList();
        if (conditions.isEmpty()) {
            return FALSE;
        }
        return conditions.size() == 1 ? conditions.getFirst() : conditions.stream().reduce(mapper).orElseThrow();
    }

    private static BiPredicate<BlockState, BlockState> parseXorCondition(JsonObject json) {
        List<JsonObject> conditionsJson = CtmUtils.unwrapConditions(json);
        if (conditionsJson.size() != 2) {
            return FALSE;
        }
        BiPredicate<BlockState, BlockState> first = CtmUtils.parseConditionInternal(conditionsJson.get(0));
        BiPredicate<BlockState, BlockState> second = CtmUtils.parseConditionInternal(conditionsJson.get(1));
        return (selfState, otherState) -> first.test((BlockState)selfState, (BlockState)otherState) ^ second.test((BlockState)selfState, (BlockState)otherState);
    }

    private static List<JsonObject> unwrapConditions(JsonObject json) {
        ArrayList<JsonObject> conditionList = new ArrayList<JsonObject>();
        JsonElement var3 = json.get("conditions");
        if (var3 instanceof JsonArray) {
            for (JsonElement jsonElement : (JsonArray)var3) {
                if (!(jsonElement instanceof JsonObject)) continue;
                JsonObject jsonObject = (JsonObject)jsonElement;
                conditionList.add(jsonObject);
            }
        }
        return conditionList;
    }

    private static BiPredicate<BlockState, BlockState> parseNotCondition(JsonObject json) {
        JsonElement var2 = json.get("condition");
        if (var2 instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)var2;
            return CtmUtils.parseConditionInternal(jsonObject).negate();
        }
        return (selfState, otherState) -> false;
    }

    private static BiPredicate<BlockState, BlockState> parseStateCondition(JsonObject json) {
        Optional<ResourceLocation> var10000 = Optional.ofNullable(GsonHelper.getAsString((JsonObject)json, (String)"block", null)).map(ResourceLocation::tryParse);
        DefaultedRegistry var10001 = BuiltInRegistries.BLOCK;
        Objects.requireNonNull(var10001);
        Optional blockOpt = var10000.flatMap(arg_0 -> ((DefaultedRegistry)var10001).getOptional(arg_0));
        if (blockOpt.isEmpty()) {
            return FALSE;
        }
        Block block = (Block)blockOpt.get();
        if (!json.has("properties")) {
            return (selfState, otherState) -> otherState.is(block);
        }
        JsonElement propertiesElem = json.get("properties");
        if (!propertiesElem.isJsonObject()) {
            return FALSE;
        }
        HashMap properties = new HashMap();
        for (Map.Entry jsonEntry : propertiesElem.getAsJsonObject().asMap().entrySet()) {
            Property property = block.getStateDefinition().getProperty((String)jsonEntry.getKey());
            if (property == null || !GsonHelper.isStringValue((JsonElement)((JsonElement)jsonEntry.getValue()))) continue;
            property.getValue(((JsonElement)jsonEntry.getValue()).getAsString()).ifPresent(value -> properties.put(property, value));
        }
        return (selfState, otherState) -> {
            if (!otherState.is(block)) {
                return false;
            }
            for (Map.Entry propertyTestValue : properties.entrySet()) {
                if (otherState.getValue((Property)propertyTestValue.getKey()) == propertyTestValue.getValue()) continue;
                return false;
            }
            return true;
        };
    }

    private static BiPredicate<BlockState, BlockState> parseTagCondition(JsonObject json) {
        TagKey tag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)Objects.requireNonNull(ResourceLocation.tryParse((String)json.get("tag").getAsString())));
        return (selfState, otherState) -> otherState.is(tag);
    }

    public static CtmState.ConnectionCheck check(AppearanceAndTintGetter level, BlockState state, BlockPos pos, Direction direction, BiPredicate<BlockState, BlockState> predicate) {
        return (fromPos, fromState, fromAppearance) -> predicate.test(level.getAppearance(state, pos, direction, fromState, fromPos), fromAppearance);
    }

    public static boolean checkRelative(AppearanceAndTintGetter level, BlockState state, BlockPos pos, Direction direction) {
        BlockPos relativePos = pos.relative(direction);
        BlockState otherState = level.getBlockState(relativePos);
        BlockState stateAppearance = level.getAppearance(state, pos, direction, otherState, relativePos);
        BlockState otherStateAppearance = level.getAppearance(otherState, relativePos, direction.getOpposite(), state, pos);
        return !stateAppearance.isAir() && otherStateAppearance.is(stateAppearance.getBlock());
    }

    public static MMRAthenaQuad athenaQuadWithState(int offset, ConnectedTextureMap map, Direction direction, boolean first, boolean second, boolean firstSecond, float left, float right, float top, float bottom, int tint) {
        return CtmUtils.athenaQuadWithState(offset, map, direction, first, second, firstSecond, left, right, top, bottom, 0.0f, tint);
    }

    public static MMRAthenaQuad athenaQuadWithState(int offset, ConnectedTextureMap map, Direction direction, boolean first, boolean second, boolean firstSecond, float left, float right, float top, float bottom, float depth, int tint) {
        int tex = CtmUtils.getTexture(first, second, firstSecond, offset);
        int texture = map.getTexture(direction, tex);
        return new MMRAthenaQuad(texture, left, right, top, bottom, Rotation.NONE, depth, true, tex <= 1 ? 4 : tint);
    }

    public static List<BakedQuad> bakeQuad(MMRAthenaQuad quad, Direction direction, TextureAtlasSprite sprite, TintProvider tint, BlockModelRotation rotation) {
        Vector3f start = CtmUtils.getStartPos(quad, direction);
        Vector3f end = CtmUtils.getEndPos(quad, direction);
        BlockElementFace face = MMRAthenaBlockElementFace.of(quad, direction, start, end, tint);
        BlockElement element = new BlockElement(start, end, Map.of(direction.getOpposite(), face), null, false);
        return UnbakedGeometryHelper.bakeElements(List.of(element), mat -> sprite, (ModelState)rotation);
    }

    public static Vector3f getStartPos(MMRAthenaQuad quad, Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> new Vector3f((1.0f - quad.right()) * 16.0f, quad.top() * 16.0f, quad.depth() * 16.0f);
            case Direction.SOUTH -> new Vector3f(quad.left() * 16.0f, quad.top() * 16.0f, (1.0f - quad.depth()) * 16.0f);
            case Direction.WEST -> new Vector3f(quad.depth() * 16.0f, quad.top() * 16.0f, quad.left() * 16.0f);
            case Direction.EAST -> new Vector3f((1.0f - quad.depth()) * 16.0f, quad.top() * 16.0f, (1.0f - quad.right()) * 16.0f);
            case Direction.DOWN -> new Vector3f(quad.left() * 16.0f, quad.depth() * 16.0f, quad.top() * 16.0f);
            case Direction.UP -> new Vector3f(quad.left() * 16.0f, (1.0f - quad.depth()) * 16.0f, (1.0f - quad.bottom()) * 16.0f);
        };
    }

    public static Vector3f getEndPos(MMRAthenaQuad quad, Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> new Vector3f((1.0f - quad.left()) * 16.0f, quad.bottom() * 16.0f, quad.depth() * 16.0f);
            case Direction.SOUTH -> new Vector3f(quad.right() * 16.0f, quad.bottom() * 16.0f, (1.0f - quad.depth()) * 16.0f);
            case Direction.WEST -> new Vector3f(quad.depth() * 16.0f, quad.bottom() * 16.0f, quad.right() * 16.0f);
            case Direction.EAST -> new Vector3f((1.0f - quad.depth()) * 16.0f, quad.bottom() * 16.0f, (1.0f - quad.left()) * 16.0f);
            case Direction.DOWN -> new Vector3f(quad.right() * 16.0f, quad.depth() * 16.0f, quad.bottom() * 16.0f);
            case Direction.UP -> new Vector3f(quad.right() * 16.0f, quad.depth() * 16.0f, (1.0f - quad.top()) * 16.0f);
        };
    }
}

