/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.integration.athena.model.hatch;

import es.degrassi.mmreborn.ModularMachineryReborn;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public record HatchTextureData(String baseTextureName, @Nullable ResourceLocation baseTexture, ResourceLocation defaultBaseTexture, String overlayTextureName, @Nullable ResourceLocation overlayTexture, ResourceLocation defaultOverlayTexture, boolean usesReinforcedOverlay, ResourceLocation defaultModel) {
    @Nullable
    private final ResourceLocation baseTexture;
    @Nullable
    private final ResourceLocation overlayTexture;

    public ResourceLocation baseTexture() {
        return Optional.ofNullable(this.baseTexture).orElse(this.defaultBaseTexture);
    }

    public ResourceLocation overlayTexture() {
        return Optional.ofNullable(this.overlayTexture).orElse(this.defaultOverlayTexture);
    }

    public boolean hasDefaultTextures() {
        if (this.baseTexture == null || this.overlayTexture == null || this.defaultBaseTexture == null || this.defaultOverlayTexture == null) {
            return true;
        }
        return this.defaultBaseTexture.equals((Object)this.baseTexture) && this.defaultOverlayTexture.equals((Object)this.overlayTexture);
    }

    public static HatchTextureData withDefault(String modelId) {
        return new HatchTextureData(null, null, null, null, null, null, false, ModularMachineryReborn.rl("default/hatch_" + modelId));
    }

    public HatchTextureData derive(String name, ResourceLocation texture, ResourceLocation defaultTexture, boolean base, boolean reinforced) {
        return new HatchTextureData(base ? name : this.baseTextureName, base ? texture : this.baseTexture, base ? defaultTexture : this.defaultBaseTexture, !base ? name : this.overlayTextureName, !base ? texture : this.overlayTexture, !base ? defaultTexture : this.defaultOverlayTexture, reinforced, this.defaultModel);
    }

    public HatchTextureData derive(String baseTextureName, ResourceLocation baseTexture, ResourceLocation defaultBaseTexture, String overlayTextureName, ResourceLocation overlayTexture, ResourceLocation defaultOverlayTexture, boolean reinforced) {
        return new HatchTextureData(baseTextureName, baseTexture, defaultBaseTexture, overlayTextureName, overlayTexture, defaultOverlayTexture, reinforced, this.defaultModel);
    }
}

