/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.integration.athena.model.hatch;

import earth.terrarium.athena.api.client.neoforge.WrappedGetter;
import earth.terrarium.athena.api.client.utils.AppearanceAndTintGetter;
import earth.terrarium.athena.api.client.utils.NullableEnumMap;
import es.degrassi.mmreborn.client.integration.athena.model.MMRBakedModel;
import es.degrassi.mmreborn.client.integration.athena.model.hatch.HatchBlockModel;
import es.degrassi.mmreborn.client.integration.athena.model.hatch.HatchTextureData;
import es.degrassi.mmreborn.client.integration.athena.utils.MMRAthenaQuad;
import es.degrassi.mmreborn.client.model.hatch.DefaultHatchBakedModel;
import es.degrassi.mmreborn.common.block.BlockMachineComponent;
import es.degrassi.mmreborn.common.util.MMRLogger;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HatchBakedModel
implements MMRBakedModel {
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP, Direction.DOWN};
    public static final ModelProperty<NullableEnumMap<Direction, Map<Direction, List<MMRAthenaQuad>>>> DATA = new ModelProperty();
    public static final ModelProperty<HatchTextureData> TEXTURE_DATA = new ModelProperty();
    private final HatchBlockModel model;
    private final Int2ObjectMap<TextureAtlasSprite> textures;
    private final ModelBaker baker;
    private final Function<Material, TextureAtlasSprite> spriteGetter;

    public HatchBakedModel(ModelBaker baker, HatchBlockModel model, Function<Material, TextureAtlasSprite> function) {
        this.model = model;
        this.textures = this.model.getTextures(function);
        this.baker = baker;
        this.spriteGetter = function;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState blockState, @Nullable Direction side, @NotNull RandomSource randomSource, @NotNull ModelData data, @Nullable RenderType renderType) {
        try {
            HatchTextureData textureData = (HatchTextureData)data.get(TEXTURE_DATA);
            if (blockState != null && !((Boolean)blockState.getValue(BlockMachineComponent.CONNECT_TEXTURES)).booleanValue() || textureData != null && !textureData.hasDefaultTextures()) {
                DefaultHatchBakedModel defaultHatchBakedModel = new DefaultHatchBakedModel(this.baker, this.spriteGetter);
                assert (textureData != null);
                return defaultHatchBakedModel.getQuads(blockState, side, randomSource, ModelData.builder().with(DefaultHatchBakedModel.MODEL, (Object)textureData.defaultModel()).with(DefaultHatchBakedModel.BASE_TEXTURE_NAME, (Object)textureData.baseTextureName()).with(DefaultHatchBakedModel.OVERLAY_TEXTURE_NAME, (Object)textureData.overlayTextureName()).with(DefaultHatchBakedModel.BASE_TEXTURE, (Object)textureData.baseTexture()).with(DefaultHatchBakedModel.OVERLAY_TEXTURE, (Object)textureData.overlayTexture()).build(), renderType);
            }
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            Map values = data.has(DATA) ? (Map)Objects.requireNonNull((NullableEnumMap)data.get(DATA)).getOrDefault((Object)side, Map.of()) : this.model.getDefaultQuads(side, null);
            values.forEach((dir, quadList) -> {
                quads.addAll(this.bakeQuads((List<MMRAthenaQuad>)quadList, (Direction)dir));
                int texture = this.model.materials.getTexture(dir, 5);
                if (texture != 0) {
                    if (blockState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                        Direction facing = (Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                        if (facing == dir) {
                            quads.addAll(this.bakeQuads(List.of(MMRAthenaQuad.withSprite(5, -1.0E-4f, -1)), (Direction)dir));
                        }
                    } else {
                        quads.addAll(this.bakeQuads(List.of(MMRAthenaQuad.withSprite(5, -1.0E-4f, -1)), (Direction)dir));
                    }
                }
            });
            return quads;
        }
        catch (Exception e) {
            MMRLogger.INSTANCE.error("Error occurred while getting quads of Hatch Athena block model", (Throwable)e);
            throw e;
        }
    }

    @NotNull
    public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData data) {
        HatchTextureData textureData = (HatchTextureData)data.get(TEXTURE_DATA);
        if (textureData != null && !textureData.hasDefaultTextures()) {
            return data.derive().build();
        }
        WrappedGetter getter = new WrappedGetter(level);
        NullableEnumMap quads = new NullableEnumMap(Direction.class);
        HashMap nonCullQuads = new HashMap();
        for (Direction direction : DIRECTIONS) {
            ArrayList<MMRAthenaQuad> culledQuads = new ArrayList<MMRAthenaQuad>();
            ArrayList<MMRAthenaQuad> unculledQuads = new ArrayList<MMRAthenaQuad>();
            for (MMRAthenaQuad quad : this.model.getQuads((AppearanceAndTintGetter)getter, state, pos, direction, null)) {
                if (quad.cull()) {
                    culledQuads.add(quad);
                    continue;
                }
                unculledQuads.add(quad);
            }
            quads.put((Enum)direction, Map.of(direction, culledQuads));
            nonCullQuads.put(direction, unculledQuads);
        }
        quads.put(null, nonCullQuads);
        return data.derive().with(DATA, (Object)quads).build();
    }

    @Override
    @Generated
    public Int2ObjectMap<TextureAtlasSprite> getTextures() {
        return this.textures;
    }
}

