/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.integration.athena.model.controller;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import earth.terrarium.athena.api.client.models.AthenaBlockModel;
import earth.terrarium.athena.api.client.models.AthenaModelAttributes;
import earth.terrarium.athena.api.client.models.AthenaModelFactory;
import earth.terrarium.athena.api.client.models.TintProvider;
import earth.terrarium.athena.api.client.utils.AppearanceAndTintGetter;
import earth.terrarium.athena.api.client.utils.CtmState;
import earth.terrarium.athena.impl.client.models.ctm.ConnectedTextureMap;
import es.degrassi.mmreborn.client.integration.athena.model.MMRAthenaBlockModel;
import es.degrassi.mmreborn.client.integration.athena.utils.CtmUtils;
import es.degrassi.mmreborn.client.integration.athena.utils.MMRAthenaQuad;
import es.degrassi.mmreborn.common.block.BlockMachineComponent;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.state.BlockState;

public class ControllerBlockModel
implements MMRAthenaBlockModel {
    public static final AthenaModelFactory FACTORY = new Factory();
    final ConnectedTextureMap materials;
    private final BiPredicate<BlockState, BlockState> connectTo;
    private final AthenaModelAttributes attributes;

    public ControllerBlockModel(ConnectedTextureMap materials, BiPredicate<BlockState, BlockState> connectTo, AthenaModelAttributes attributes) {
        this.materials = materials;
        this.connectTo = connectTo;
        this.attributes = attributes;
    }

    @Override
    public List<MMRAthenaQuad> getQuads(AppearanceAndTintGetter level, BlockState state, BlockPos pos, Direction direction, Void ignored) {
        if (CtmUtils.checkRelative(level, state, pos, direction)) {
            return List.of();
        }
        CtmState ctm = CtmState.from((AppearanceAndTintGetter)level, (BlockState)state, (BlockPos)pos, (Direction)direction, (CtmState.ConnectionCheck)CtmUtils.check(level, state, pos, direction, (other, self) -> this.connectTo.test((BlockState)other, (BlockState)self) && (Boolean)other.getValue(BlockMachineComponent.CONNECT_TEXTURES) != false && (Boolean)self.getValue(BlockMachineComponent.CONNECT_TEXTURES) != false));
        if (ctm.allTrue()) {
            return List.of(MMRAthenaQuad.withSprite(this.materials.getTexture(direction, 1), 4));
        }
        ArrayList quads = Lists.newArrayList();
        quads.add(CtmUtils.athenaQuadWithState(0, this.materials, direction, ctm.up(), ctm.left(), ctm.upLeft(), 0.0f, 0.5f, 1.0f, 0.5f, 4));
        quads.add(CtmUtils.athenaQuadWithState(0, this.materials, direction, ctm.up(), ctm.right(), ctm.upRight(), 0.5f, 1.0f, 1.0f, 0.5f, 4));
        quads.add(CtmUtils.athenaQuadWithState(0, this.materials, direction, ctm.down(), ctm.left(), ctm.downLeft(), 0.0f, 0.5f, 0.5f, 0.0f, 4));
        quads.add(CtmUtils.athenaQuadWithState(0, this.materials, direction, ctm.down(), ctm.right(), ctm.downRight(), 0.5f, 1.0f, 0.5f, 0.0f, 4));
        if (this.materials.getTexture(direction, 6) != 0 && this.materials.getTexture(direction, 7) != 0 && this.materials.getTexture(direction, 8) != 0 && this.materials.getTexture(direction, 9) != 0) {
            MMRAthenaQuad quad = CtmUtils.athenaQuadWithState(5, this.materials, direction, ctm.up(), ctm.left(), ctm.upLeft(), 0.0f, 0.5f, 1.0f, 0.5f, -1);
            quads.add(quad);
            quad = CtmUtils.athenaQuadWithState(5, this.materials, direction, ctm.up(), ctm.right(), ctm.upRight(), 0.5f, 1.0f, 1.0f, 0.5f, -1);
            quads.add(quad);
            quad = CtmUtils.athenaQuadWithState(5, this.materials, direction, ctm.down(), ctm.left(), ctm.downLeft(), 0.0f, 0.5f, 0.5f, 0.0f, -1);
            quads.add(quad);
            quad = CtmUtils.athenaQuadWithState(5, this.materials, direction, ctm.down(), ctm.right(), ctm.downRight(), 0.5f, 1.0f, 0.5f, 0.0f, -1);
            quads.add(quad);
        }
        return quads;
    }

    @Override
    public Map<Direction, List<MMRAthenaQuad>> getDefaultQuads(Direction direction, Void ignored) {
        if (direction == null) {
            return Map.of();
        }
        HashMap defaultQuads = Maps.newHashMap();
        List quads = defaultQuads.computeIfAbsent(direction, key -> Lists.newArrayList());
        quads.add(CtmUtils.athenaQuadWithState(0, this.materials, direction, false, false, false, 0.0f, 0.5f, 1.0f, 0.5f, 4));
        quads.add(CtmUtils.athenaQuadWithState(0, this.materials, direction, false, false, false, 0.5f, 1.0f, 1.0f, 0.5f, 4));
        quads.add(CtmUtils.athenaQuadWithState(0, this.materials, direction, false, false, false, 0.0f, 0.5f, 0.5f, 0.0f, 4));
        quads.add(CtmUtils.athenaQuadWithState(0, this.materials, direction, false, false, false, 0.5f, 1.0f, 0.5f, 0.0f, 4));
        if (this.materials.getTexture(direction, 6) != 0 && this.materials.getTexture(direction, 7) != 0 && this.materials.getTexture(direction, 8) != 0 && this.materials.getTexture(direction, 9) != 0) {
            MMRAthenaQuad quad = CtmUtils.athenaQuadWithState(5, this.materials, direction, false, false, false, 0.0f, 0.5f, 1.0f, 0.5f, -1);
            quads.add(quad);
            quad = CtmUtils.athenaQuadWithState(5, this.materials, direction, false, false, false, 0.5f, 1.0f, 1.0f, 0.5f, -1);
            quads.add(quad);
            quad = CtmUtils.athenaQuadWithState(5, this.materials, direction, false, false, false, 0.0f, 0.5f, 0.5f, 0.0f, -1);
            quads.add(quad);
            quad = CtmUtils.athenaQuadWithState(5, this.materials, direction, false, false, false, 0.5f, 1.0f, 0.5f, 0.0f, -1);
            quads.add(quad);
        }
        return defaultQuads;
    }

    public Int2ObjectMap<TextureAtlasSprite> getTextures(Function<Material, TextureAtlasSprite> function) {
        return this.materials.getTextures(function);
    }

    @Generated
    public AthenaModelAttributes getAttributes() {
        return this.attributes;
    }

    public static class Factory
    implements AthenaModelFactory {
        private Factory() {
        }

        public Supplier<AthenaBlockModel> create(JsonObject json) {
            ConnectedTextureMap materials = CtmUtils.tryParse(GsonHelper.getAsJsonObject((JsonObject)json, (String)"ctm_textures"), Factory::parseDefaultMaterials);
            if (materials == null) {
                materials = CtmUtils.tryParse(GsonHelper.getAsJsonObject((JsonObject)json, (String)"ctm_textures"), Factory::parseMaterials);
            }
            if (materials == null) {
                throw new JsonSyntaxException("Expected either ctm_textures to have 5-6 entries for all textures or have directional textures for each direction or to have some directions and a default textures object.");
            }
            BiPredicate<BlockState, BlockState> conditions = CtmUtils.parseCondition(json);
            ConnectedTextureMap finalMaterials = materials;
            return () -> new ControllerBlockModel(finalMaterials, conditions, new AthenaModelAttributes((TintProvider)new TintProvider.Index(4), RenderType.CUTOUT));
        }

        private static ConnectedTextureMap parseMaterials(JsonObject json) {
            ConnectedTextureMap materials = new ConnectedTextureMap();
            for (Direction direction : Direction.values()) {
                if (GsonHelper.isStringValue((JsonObject)json, (String)direction.getSerializedName())) {
                    materials.put(direction, CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)direction.getSerializedName())));
                    continue;
                }
                Int2ObjectMap<Material> directionMaterials = CtmUtils.parseCtmMaterials(GsonHelper.getAsJsonObject((JsonObject)json, (String)direction.getSerializedName(), (JsonObject)GsonHelper.getAsJsonObject((JsonObject)json, (String)"default")));
                materials.put(direction, directionMaterials);
            }
            return materials;
        }

        private static ConnectedTextureMap parseDefaultMaterials(JsonObject json) {
            Int2ObjectMap<Material> materials = CtmUtils.parseCtmMaterials(json);
            ConnectedTextureMap connectedTextureMap = new ConnectedTextureMap();
            for (Direction direction : Direction.values()) {
                connectedTextureMap.put(direction, materials);
            }
            return connectedTextureMap;
        }
    }
}

