/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.integration.athena.model.controller;

import earth.terrarium.athena.api.client.neoforge.WrappedGetter;
import earth.terrarium.athena.api.client.utils.AppearanceAndTintGetter;
import earth.terrarium.athena.api.client.utils.NullableEnumMap;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.client.integration.athena.model.MMRBakedModel;
import es.degrassi.mmreborn.client.integration.athena.model.controller.ControllerBlockModel;
import es.degrassi.mmreborn.client.integration.athena.model.controller.ControllerData;
import es.degrassi.mmreborn.client.integration.athena.utils.MMRAthenaQuad;
import es.degrassi.mmreborn.client.model.controller.ControllerOverrideList;
import es.degrassi.mmreborn.common.block.BlockMachineComponent;
import es.degrassi.mmreborn.common.item.ControllerItem;
import es.degrassi.mmreborn.common.machine.DynamicMachine;
import es.degrassi.mmreborn.common.util.MMRLogger;
import es.degrassi.mmreborn.common.util.MachineModelLocation;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ControllerBakedModel
implements MMRBakedModel {
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP, Direction.DOWN};
    public static final ModelProperty<ControllerData> DATA = new ModelProperty();
    private final ControllerOverrideList overrideList = new ControllerOverrideList();
    private final ControllerBlockModel model;
    private final Int2ObjectMap<TextureAtlasSprite> textures;

    public ControllerBakedModel(ControllerBlockModel model, Function<Material, TextureAtlasSprite> function) {
        this.model = model;
        this.textures = this.model.getTextures(function);
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData data, @Nullable RenderType type) {
        try {
            boolean isCustom;
            ControllerData machine = (ControllerData)data.get(DATA);
            if (machine == null) {
                machine = new ControllerData(DynamicMachine.DUMMY, (NullableEnumMap<Direction, Map<Direction, List<MMRAthenaQuad>>>)new NullableEnumMap(Direction.class));
            }
            if ((isCustom = machine.hasCustomModel()) || state != null && !((Boolean)state.getValue(BlockMachineComponent.CONNECT_TEXTURES)).booleanValue()) {
                return new es.degrassi.mmreborn.client.model.controller.ControllerBakedModel().getQuads(state, side, rand, ModelData.builder().with(es.degrassi.mmreborn.client.model.controller.ControllerBakedModel.MACHINE, (Object)machine.machine()).build(), type);
            }
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            Map values = machine.hasData() ? (Map)machine.data().getOrDefault((Object)side, Map.of()) : this.model.getDefaultQuads(side, null);
            values.forEach((dir, quadList) -> {
                quads.addAll(this.bakeQuads((List<MMRAthenaQuad>)quadList, (Direction)dir));
                int texture = this.model.materials.getTexture(dir, 5);
                if (texture != 0) {
                    if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                        if (facing == dir) {
                            quads.addAll(this.bakeQuads(List.of(MMRAthenaQuad.withSprite(5, -1.0E-4f, -1)), (Direction)dir));
                        }
                    } else {
                        quads.addAll(this.bakeQuads(List.of(MMRAthenaQuad.withSprite(5, -1.0E-4f, -1)), (Direction)dir));
                    }
                }
            });
            return quads;
        }
        catch (Exception e) {
            MMRLogger.INSTANCE.error("Error occurred while getting quads of Controller Athena block model", (Throwable)e);
            throw e;
        }
    }

    public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData data) {
        ControllerData textureData = (ControllerData)data.get(DATA);
        if (textureData == null) {
            textureData = new ControllerData(DynamicMachine.DUMMY, null);
        }
        if (textureData.hasCustomModel()) {
            return data.derive().build();
        }
        WrappedGetter getter = new WrappedGetter(level);
        NullableEnumMap quads = new NullableEnumMap(Direction.class);
        HashMap nonCullQuads = new HashMap();
        for (Direction direction : DIRECTIONS) {
            ArrayList<MMRAthenaQuad> culledQuads = new ArrayList<MMRAthenaQuad>();
            ArrayList<MMRAthenaQuad> unculledQuads = new ArrayList<MMRAthenaQuad>();
            for (MMRAthenaQuad quad : this.model.getQuads((AppearanceAndTintGetter)getter, state, pos, direction, null)) {
                if (quad.cull()) {
                    culledQuads.add(quad);
                    continue;
                }
                unculledQuads.add(quad);
            }
            quads.put((Enum)direction, Map.of(direction, culledQuads));
            nonCullQuads.put(direction, unculledQuads);
        }
        quads.put(null, nonCullQuads);
        return data.derive().with(DATA, (Object)new ControllerData(textureData.machine(), (NullableEnumMap<Direction, Map<Direction, List<MMRAthenaQuad>>>)quads)).build();
    }

    @Override
    public boolean isGui3d() {
        return true;
    }

    @Override
    public boolean isCustomRenderer() {
        return true;
    }

    @Override
    @NotNull
    public ItemOverrides getOverrides() {
        return this.overrideList;
    }

    @Override
    public TextureAtlasSprite getParticleIcon() {
        return this.getParticleIcon(ModelData.EMPTY);
    }

    public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        return this.getMachineModel(data).getParticleIcon(data);
    }

    @Override
    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        try {
            return this.getMachineModel(data).getRenderTypes(state, rand, data);
        }
        catch (IllegalArgumentException ignored) {
            return ChunkRenderTypeSet.all();
        }
    }

    public List<RenderType> getRenderTypes(ItemStack stack, boolean fabulous) {
        return ControllerItem.getMachine(stack).map(machine -> this.getMachineItemModel(machine.getControllerModel()).getRenderTypes(stack, fabulous)).orElse(List.of(RenderTypeHelper.getFallbackItemRenderType((ItemStack)stack, (BakedModel)this, (boolean)fabulous)));
    }

    private BakedModel getMachineModel(@NotNull ModelData data) {
        ControllerData machine = (ControllerData)data.get(DATA);
        BakedModel model = machine != null ? this.getMachineBlockModel(machine.modelLocation()) : Minecraft.getInstance().getModelManager().getModel(ModelResourceLocation.standalone((ResourceLocation)MachineModelLocation.DEFAULT.getLoc()));
        return model;
    }

    public BakedModel getMachineBlockModel(@Nullable MachineModelLocation blockModelLocation) {
        BakedModel missing;
        BakedModel model = missing = Minecraft.getInstance().getModelManager().getMissingModel();
        if (blockModelLocation != null) {
            if (blockModelLocation.getState() != null) {
                model = Minecraft.getInstance().getBlockRenderer().getBlockModel(blockModelLocation.getState());
            } else if (blockModelLocation.getLoc() != null && blockModelLocation.getProperties() != null) {
                model = Minecraft.getInstance().getModelManager().getModel(new ModelResourceLocation(blockModelLocation.getLoc(), blockModelLocation.getProperties()));
            } else if (blockModelLocation.getLoc() != null) {
                model = Minecraft.getInstance().getModelManager().getModel(ModelResourceLocation.standalone((ResourceLocation)blockModelLocation.getLoc()));
            }
        }
        if (model == missing) {
            model = Minecraft.getInstance().getModelManager().getModel(ModelResourceLocation.standalone((ResourceLocation)MachineModelLocation.DEFAULT.getLoc()));
        }
        return model;
    }

    @Nullable
    public BakedModel getMachineItemModel(@Nullable MachineModelLocation itemModelLocation) {
        BakedModel missing;
        BakedModel model = missing = Minecraft.getInstance().getModelManager().getMissingModel();
        if (itemModelLocation != null) {
            if (itemModelLocation.getItem() != null && itemModelLocation.getItem() != Items.AIR) {
                model = Minecraft.getInstance().getItemRenderer().getItemModelShaper().getItemModel(itemModelLocation.getItem());
            } else if (itemModelLocation.getLoc() != null && !itemModelLocation.getLoc().equals((Object)MachineModelLocation.DEFAULT.getLoc())) {
                Item item = (Item)BuiltInRegistries.ITEM.get(itemModelLocation.getLoc());
                model = itemModelLocation.getProperties() != null ? Minecraft.getInstance().getModelManager().getModel(new ModelResourceLocation(itemModelLocation.getLoc(), itemModelLocation.getProperties())) : (item != Items.AIR && Minecraft.getInstance().getItemRenderer().getItemModelShaper().getItemModel(item) != null ? Minecraft.getInstance().getItemRenderer().getItemModelShaper().getItemModel(item) : Minecraft.getInstance().getModelManager().getModel(ModelResourceLocation.standalone((ResourceLocation)itemModelLocation.getLoc())));
            }
        }
        if (model == missing) {
            model = this.getMachineBlockModel(itemModelLocation);
        }
        if (model == missing) {
            model = Minecraft.getInstance().getModelManager().getModel(ModelResourceLocation.standalone((ResourceLocation)ModularMachineryReborn.rl("controller")));
        }
        return model;
    }

    @Override
    @Generated
    public Int2ObjectMap<TextureAtlasSprite> getTextures() {
        return this.textures;
    }
}

