/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.integration.athena.model;

import earth.terrarium.athena.api.client.models.TintProvider;
import es.degrassi.mmreborn.client.integration.athena.utils.CtmUtils;
import es.degrassi.mmreborn.client.integration.athena.utils.MMRAthenaQuad;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.NeoForgeConfig;
import org.jetbrains.annotations.NotNull;

public interface MMRBakedModel
extends IDynamicBakedModel {
    public Int2ObjectMap<TextureAtlasSprite> getTextures();

    default public List<BakedQuad> bakeQuads(List<MMRAthenaQuad> quads, Direction direction) {
        ArrayList<BakedQuad> bakedQuads = new ArrayList<BakedQuad>(quads.size());
        for (MMRAthenaQuad quad : quads) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)this.getTextures().get(quad.sprite());
            if (sprite == null) continue;
            bakedQuads.addAll(CtmUtils.bakeQuad(quad, direction, sprite, (TintProvider)new TintProvider.Index(quad.tint()), BlockModelRotation.X0_Y0));
        }
        return bakedQuads;
    }

    default public List<BakedQuad> bakeQuads(List<MMRAthenaQuad> quads, Direction direction, BlockModelRotation rotation) {
        ArrayList<BakedQuad> bakedQuads = new ArrayList<BakedQuad>(quads.size());
        for (MMRAthenaQuad quad : quads) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)this.getTextures().get(quad.sprite());
            if (sprite == null) continue;
            bakedQuads.addAll(CtmUtils.bakeQuad(quad, direction, sprite, (TintProvider)new TintProvider.Index(quad.tint()), rotation));
        }
        return bakedQuads;
    }

    default public boolean useAmbientOcclusion() {
        return (Boolean)NeoForgeConfig.CLIENT.experimentalForgeLightPipelineEnabled.get();
    }

    default public boolean isGui3d() {
        return false;
    }

    default public boolean usesBlockLight() {
        return true;
    }

    default public boolean isCustomRenderer() {
        return false;
    }

    @NotNull
    default public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    @NotNull
    default public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.CUTOUT});
    }

    @NotNull
    default public TextureAtlasSprite getParticleIcon() {
        if (this.getTextures().containsKey(0)) {
            return (TextureAtlasSprite)this.getTextures().get(0);
        }
        return Minecraft.getInstance().getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS).getSprite(MissingTextureAtlasSprite.getLocation());
    }
}

