/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.integration.athena.model;

import earth.terrarium.athena.api.client.models.AthenaBlockModel;
import earth.terrarium.athena.api.client.models.NotNullUnbakedModel;
import earth.terrarium.athena.api.client.neoforge.AthenaBakedModel;
import es.degrassi.mmreborn.client.integration.athena.model.casing.CasingBakedModel;
import es.degrassi.mmreborn.client.integration.athena.model.casing.CasingBlockModel;
import es.degrassi.mmreborn.client.integration.athena.model.controller.ControllerBakedModel;
import es.degrassi.mmreborn.client.integration.athena.model.controller.ControllerBlockModel;
import es.degrassi.mmreborn.client.integration.athena.model.hatch.HatchBakedModel;
import es.degrassi.mmreborn.client.integration.athena.model.hatch.HatchBlockModel;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class MMRAthenaUnbakedModel
implements NotNullUnbakedModel {
    private final Supplier<AthenaBlockModel> model;

    public MMRAthenaUnbakedModel(Supplier<AthenaBlockModel> athenaBlockModelSupplier) {
        this.model = athenaBlockModelSupplier;
    }

    @NotNull
    public Collection<ResourceLocation> getDependencies() {
        return List.of();
    }

    public void resolveParents(@NotNull Function<ResourceLocation, UnbakedModel> function) {
    }

    @NotNull
    public BakedModel bake(@NotNull ModelBaker baker, @NotNull Function<Material, TextureAtlasSprite> function, @NotNull ModelState modelState) {
        AthenaBlockModel athenaBlockModel = this.model.get();
        if (athenaBlockModel instanceof CasingBlockModel) {
            CasingBlockModel casingBlockModel = (CasingBlockModel)athenaBlockModel;
            return new CasingBakedModel(casingBlockModel, function);
        }
        athenaBlockModel = this.model.get();
        if (athenaBlockModel instanceof HatchBlockModel) {
            HatchBlockModel hatchBlockModel = (HatchBlockModel)athenaBlockModel;
            return new HatchBakedModel(baker, hatchBlockModel, function);
        }
        athenaBlockModel = this.model.get();
        if (athenaBlockModel instanceof ControllerBlockModel) {
            ControllerBlockModel controllerBlockModel = (ControllerBlockModel)athenaBlockModel;
            return new ControllerBakedModel(controllerBlockModel, function);
        }
        return new AthenaBakedModel(this.model.get(), function);
    }
}

