/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.BlockIngredient;
import es.degrassi.mmreborn.api.PartialBlockState;
import es.degrassi.mmreborn.client.util.RenderTypes;
import es.degrassi.mmreborn.common.data.MMRConfig;
import es.degrassi.mmreborn.common.util.CycleTimer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.neoforged.neoforge.client.model.data.ModelData;

public class StructureRenderer {
    private final int time;
    private final long start;
    private final Map<Direction, Map<BlockPos, BlockIngredient>> blocksGetter = new HashMap<Direction, Map<BlockPos, BlockIngredient>>();
    private final Map<Map<BlockPos, BlockIngredient>, CycleTimer> timers = new HashMap<Map<BlockPos, BlockIngredient>, CycleTimer>();

    public StructureRenderer(int time, Function<Direction, Map<BlockPos, BlockIngredient>> blocksGetter) {
        this.start = System.currentTimeMillis();
        int configTagTime = (Integer)MMRConfig.get().blockTagCycleTime.get();
        AtomicInteger maxTime = new AtomicInteger(time);
        for (Direction direction : Direction.values()) {
            if (direction.getAxis().isVertical()) continue;
            this.blocksGetter.put(direction, blocksGetter.apply(direction));
            Map<BlockPos, BlockIngredient> map = this.blocksGetter.get(direction);
            map.forEach((pos, ing) -> {
                int currentMax = maxTime.get();
                int possibleMax = Math.max(currentMax, ing.getAll().size() * configTagTime);
                if (possibleMax != currentMax) {
                    maxTime.set(possibleMax);
                }
            });
            this.timers.put(map, new CycleTimer(() -> configTagTime, false));
        }
        this.time = maxTime.get();
    }

    public void render(BlockEntityRendererProvider.Context context, PoseStack matrix, MultiBufferSource buffer, Direction direction, Level world, BlockPos machinePos) {
        Map<BlockPos, BlockIngredient> blocks = this.blocksGetter.get(direction);
        CycleTimer timer = this.timers.get(blocks);
        if (timer == null) {
            this.timers.put(blocks, new CycleTimer(() -> (Integer)MMRConfig.get().blockTagCycleTime.get(), false));
            timer = this.timers.get(blocks);
        }
        timer.onDraw();
        CycleTimer finalTimer = timer;
        blocks.forEach((pos, ingredient) -> {
            matrix.pushPose();
            matrix.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            if ((pos.getX() != 0 || pos.getY() != 0 || pos.getZ() != 0) && ingredient != BlockIngredient.ANY) {
                PartialBlockState state = finalTimer.get(ingredient.getAll());
                boolean isNot = ingredient.isNot();
                BlockPos blockPos = machinePos.offset((Vec3i)pos);
                if (state != null && state != PartialBlockState.ANY && !state.getBlockState().isAir()) {
                    if (world.getBlockState(blockPos).isAir()) {
                        matrix.pushPose();
                        matrix.translate(0.1f, 0.1f, 0.1f);
                        matrix.scale(0.8f, 0.8f, 0.8f);
                        if (isNot) {
                            this.renderTransparentNotBlock(context, world, blockPos, state, matrix, buffer);
                        } else {
                            this.renderTransparentBlock(context, world, blockPos, state, matrix, buffer);
                        }
                        matrix.popPose();
                    } else if (!ingredient.test(new BlockInWorld((LevelReader)world, blockPos, false))) {
                        matrix.pushPose();
                        matrix.translate(-5.0E-4, -5.0E-4, -5.0E-4);
                        matrix.scale(1.001f, 1.001f, 1.001f);
                        this.renderNope(matrix, buffer);
                        matrix.popPose();
                    }
                }
            }
            matrix.popPose();
        });
    }

    private void renderTransparentBlock(BlockEntityRendererProvider.Context context, Level level, BlockPos pos, PartialBlockState state, PoseStack matrix, MultiBufferSource buffer) {
        BlockEntity blockEntity;
        VertexConsumer builder = buffer.getBuffer(RenderTypes.PHANTOM);
        BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(state.getBlockState());
        Direction[] directionArray = state.getBlockState().getBlock();
        if (directionArray instanceof EntityBlock) {
            EntityBlock eb = (EntityBlock)directionArray;
            blockEntity = eb.newBlockEntity(pos, state.getBlockState());
        } else {
            blockEntity = null;
        }
        BlockEntity entity = blockEntity;
        ModelData modelData = entity != null ? entity.getModelData() : ModelData.EMPTY;
        for (Direction side : Direction.values()) {
            List quads = model.getQuads(state.getBlockState(), side, RandomSource.create((long)42L), modelData, RenderTypes.PHANTOM);
            if (quads.isEmpty()) continue;
            int packedLight = 0xF000F0;
            int packedOverlay = OverlayTexture.NO_OVERLAY;
            for (BakedQuad quad : quads) {
                int color = quad.isTinted() ? context.getBlockRenderDispatcher().blockColors.getColor(state.getBlockState(), (BlockAndTintGetter)level, pos, quad.getTintIndex()) : -1;
                float f = level.getShade(quad.getDirection(), quad.isShade());
                this.putQuadData(color, 0.8f, builder, matrix.last(), quad, f, f, f, f, packedLight, packedLight, packedLight, packedLight, packedOverlay);
            }
        }
        List quads = model.getQuads(state.getBlockState(), null, RandomSource.create((long)42L), modelData, RenderTypes.PHANTOM);
        if (!quads.isEmpty()) {
            int packedLight = 0xF000F0;
            int packedOverlay = OverlayTexture.NO_OVERLAY;
            for (BakedQuad quad : quads) {
                int color = quad.isTinted() ? context.getBlockRenderDispatcher().blockColors.getColor(state.getBlockState(), (BlockAndTintGetter)level, pos, quad.getTintIndex()) : -1;
                float f = level.getShade(quad.getDirection(), quad.isShade());
                this.putQuadData(color, 0.8f, builder, matrix.last(), quad, f, f, f, f, packedLight, packedLight, packedLight, packedLight, packedOverlay);
            }
        }
    }

    private void renderTransparentNotBlock(BlockEntityRendererProvider.Context context, Level level, BlockPos pos, PartialBlockState state, PoseStack pose, MultiBufferSource buffer) {
        this.renderTransparentBlock(context, level, pos, state, pose, buffer);
        this.renderNope(pose, buffer);
    }

    private void renderNope(PoseStack matrix, MultiBufferSource buffer) {
        VertexConsumer builder = buffer.getBuffer(RenderTypes.NOPE);
        BakedModel model = Minecraft.getInstance().getModelManager().getModel(ModelResourceLocation.standalone((ResourceLocation)ModularMachineryReborn.rl("block/nope")));
        ModelData modelData = ModelData.EMPTY;
        Arrays.stream(Direction.values()).flatMap(direction -> model.getQuads(null, direction, RandomSource.create((long)42L), modelData, RenderTypes.NOPE).stream()).forEach(quad -> builder.putBulkData(matrix.last(), quad, 1.0f, 1.0f, 1.0f, 0.8f, 0xF000F0, OverlayTexture.NO_OVERLAY, false));
        model.getQuads(null, null, RandomSource.create((long)42L), modelData, RenderTypes.NOPE).forEach(quad -> builder.putBulkData(matrix.last(), quad, 1.0f, 1.0f, 1.0f, 0.8f, 0xF000F0, OverlayTexture.NO_OVERLAY, false));
    }

    public boolean shouldRender() {
        return System.currentTimeMillis() < this.start + (long)this.time;
    }

    private void putQuadData(int color, float alpha, VertexConsumer consumer, PoseStack.Pose pose, BakedQuad quad, float brightness0, float brightness1, float brightness2, float brightness3, int lightmap0, int lightmap1, int lightmap2, int lightmap3, int packedOverlay) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        consumer.putBulkData(pose, quad, new float[]{brightness0, brightness1, brightness2, brightness3}, r, g, b, alpha, new int[]{lightmap0, lightmap1, lightmap2, lightmap3}, packedOverlay, true);
    }
}

