/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.entity.renderer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import es.degrassi.mmreborn.api.Structure;
import es.degrassi.mmreborn.client.entity.renderer.StructureRenderer;
import es.degrassi.mmreborn.common.data.MMRConfig;
import es.degrassi.mmreborn.common.entity.StructureCheckerEntity;
import es.degrassi.mmreborn.common.machine.DynamicMachine;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class StructureCheckerRenderer
implements BlockEntityRenderer<StructureCheckerEntity> {
    public static final Map<ResourceLocation, StructureRenderer> renderers = Maps.newHashMap();
    private final BlockEntityRendererProvider.Context context;

    public StructureCheckerRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(StructureCheckerEntity machineControllerEntity, float v, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int i1) {
        DynamicMachine bound = machineControllerEntity.getBoundMachine();
        Level level = machineControllerEntity.getLevel();
        if (level == null || bound == null) {
            return;
        }
        ResourceLocation machine = bound.getRegistryName();
        if (renderers.containsKey(machine)) {
            Direction machineFacing = machineControllerEntity.getControllerFacing();
            StructureRenderer renderer = renderers.get(machine);
            if (renderer.shouldRender()) {
                renderer.render(this.context, poseStack, multiBufferSource, machineFacing, level, machineControllerEntity.getBlockPos());
            } else {
                renderers.remove(machine);
            }
        }
    }

    public static void add(ResourceLocation machine, Structure structure) {
        renderers.put(machine, new StructureRenderer((Integer)MMRConfig.get().structureRenderTime.get(), structure::getBlocks));
    }
}

