/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.entity.renderer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import es.degrassi.mmreborn.client.entity.renderer.StructureRenderer;
import es.degrassi.mmreborn.common.data.MMRConfig;
import es.degrassi.mmreborn.common.entity.MachineControllerEntity;
import es.degrassi.mmreborn.common.machine.DynamicMachine;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class ControllerRenderer
implements BlockEntityRenderer<MachineControllerEntity> {
    public static final Map<BlockPos, StructureRenderer> renderers = Maps.newHashMap();
    private final BlockEntityRendererProvider.Context context;

    public ControllerRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(MachineControllerEntity machineControllerEntity, float v, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int i1) {
        if (machineControllerEntity.getLevel() == null) {
            return;
        }
        if (renderers.containsKey(machineControllerEntity.getBlockPos())) {
            Direction machineFacing = (Direction)machineControllerEntity.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            StructureRenderer renderer = renderers.get(machineControllerEntity.getBlockPos());
            if (renderer.shouldRender()) {
                renderer.render(this.context, poseStack, multiBufferSource, machineFacing, machineControllerEntity.getLevel(), machineControllerEntity.getBlockPos());
            } else {
                renderers.remove(machineControllerEntity.getBlockPos());
            }
        }
    }

    public static void add(DynamicMachine machine, BlockPos controllerPos) {
        renderers.put(controllerPos, new StructureRenderer((Integer)MMRConfig.get().structureRenderTime.get(), machine.getPattern()::getBlocks));
    }
}

