/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.container;

import es.degrassi.mmreborn.client.ModularMachineryRebornClient;
import es.degrassi.mmreborn.client.container.ContainerBase;
import es.degrassi.mmreborn.client.container.SlotItemComponent;
import es.degrassi.mmreborn.client.screen.widget.ISlotClickHandler;
import es.degrassi.mmreborn.common.block.prop.ItemBusSize;
import es.degrassi.mmreborn.common.data.config.ItemBusConfig;
import es.degrassi.mmreborn.common.entity.base.TileItemBus;
import es.degrassi.mmreborn.common.registration.ContainerRegistration;
import es.degrassi.mmreborn.common.util.IOInventory;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBusContainer
extends ContainerBase<TileItemBus>
implements ISlotClickHandler {
    public static final int MAX_VISIBLE_ROWS = 5;
    public static final int SLOT_SIZE = 18;

    public static void open(ServerPlayer player, final TileItemBus machine) {
        player.openMenu(new MenuProvider(){

            @NotNull
            public Component getDisplayName() {
                return Component.translatable((String)"modular_machinery_reborn.gui.title.item_bus");
            }

            public AbstractContainerMenu createMenu(int id, Inventory inv, Player player) {
                return new ItemBusContainer(id, inv, machine);
            }
        }, buf -> buf.writeBlockPos(machine.getBlockPos()));
    }

    public ItemBusContainer(int id, Inventory playerInv, TileItemBus entity) {
        super(entity, playerInv.player, (MenuType)ContainerRegistration.ITEM_BUS.get(), id);
    }

    public ItemBusContainer(int id, Inventory inv, FriendlyByteBuf buffer) {
        this(id, inv, ModularMachineryRebornClient.getClientSideItemBusEntity(buffer.readBlockPos()));
    }

    @Override
    public void init() {
        super.init();
        this.addInventorySlots(((TileItemBus)this.getEntity()).getInventory(), ((TileItemBus)this.getEntity()).getSize(), new AtomicInteger(this.getFirstComponentSlotIndex()));
    }

    @Override
    protected void addPlayerSlots(AtomicInteger slotIndex) {
        int i;
        int totalRows = (int)Math.ceil((double)((TileItemBus)this.getEntity()).getSlots() * 1.0 / (double)((TileItemBus)this.getEntity()).getSize().cols);
        boolean needsScrolling = totalRows > 5;
        int visibleRows = needsScrolling ? 5 : totalRows;
        int yOffset = visibleRows * 18 + 18;
        for (i = 0; i < 9; ++i) {
            this.addSyncedSlot(new Slot((Container)this.player.getInventory(), slotIndex.getAndIncrement(), 8 + i * 18, yOffset + 54 + 3));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                int lastYOffset = yOffset + i * 18;
                this.addSyncedSlot(new Slot((Container)this.player.getInventory(), slotIndex.getAndIncrement(), 8 + j * 18, lastYOffset));
            }
        }
    }

    protected void addInventorySlots(IOInventory itemHandler, ItemBusSize size, AtomicInteger atomicInteger) {
        int xOffset = (Integer)ItemBusConfig.get().itemSlotXOffset.get();
        int yOffset = (Integer)ItemBusConfig.get().itemSlotYOffset.get();
        int cols = size.cols;
        int row = 0;
        int s = 0;
        int c = 0;
        while (s < size.slots) {
            if (c >= cols) {
                c = 0;
                ++row;
            }
            this.addSyncedSlot(new SlotItemComponent(itemHandler.getInventory().get(s), atomicInteger.getAndIncrement(), xOffset + c * 18, yOffset + row * 18));
            ++s;
            ++c;
        }
    }

    public List<SlotItemComponent> getItemList() {
        return this.slots.stream().filter(slot -> slot.getSlotIndex() >= this.getFirstComponentSlotIndex() && slot instanceof SlotItemComponent).map(slot -> (SlotItemComponent)((Object)slot)).toList();
    }

    @Override
    public void onClick(Supplier<@Nullable SlotItemComponent> slotProvider, int button, boolean hasShiftDown, ItemStack heldItem) {
        ((TileItemBus)this.getEntity()).provideComponent().getContainerProvider().setChanged();
    }
}

