/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.container;

import es.degrassi.mmreborn.client.ModularMachineryRebornClient;
import es.degrassi.mmreborn.client.container.ContainerBase;
import es.degrassi.mmreborn.client.container.SlotItemComponent;
import es.degrassi.mmreborn.common.entity.FuelTankEntity;
import es.degrassi.mmreborn.common.registration.ContainerRegistration;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import org.jetbrains.annotations.NotNull;

public class FuelTankContainer
extends ContainerBase<FuelTankEntity> {
    public static void open(ServerPlayer player, final FuelTankEntity machine) {
        player.openMenu(new MenuProvider(){

            @NotNull
            public Component getDisplayName() {
                return Component.translatable((String)"modular_machinery_reborn.gui.title.fuel_tank");
            }

            public AbstractContainerMenu createMenu(int id, Inventory inv, Player player) {
                return new FuelTankContainer(id, inv, machine);
            }
        }, buf -> buf.writeBlockPos(machine.getBlockPos()));
    }

    public FuelTankContainer(int id, Inventory playerInv, FuelTankEntity entity) {
        super(entity, playerInv.player, (MenuType)ContainerRegistration.FUEL_TANK.get(), id);
    }

    public FuelTankContainer(int id, Inventory inv, FriendlyByteBuf buffer) {
        this(id, inv, ModularMachineryRebornClient.getClientSideFuelTankEntity(buffer.readBlockPos()));
    }

    @Override
    public void init() {
        super.init();
        this.addSyncedSlot(new SlotItemComponent(((FuelTankEntity)this.getEntity()).getInventory().getInventory().get(0), new AtomicInteger(this.getFirstComponentSlotIndex()).getAndIncrement(), 43, 32));
    }
}

