/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client;

import com.google.common.collect.Lists;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.client.ClientScheduler;
import es.degrassi.mmreborn.client.entity.renderer.ControllerRenderer;
import es.degrassi.mmreborn.client.entity.renderer.StructureCheckerRenderer;
import es.degrassi.mmreborn.client.integration.athena.MMRAthenaModels;
import es.degrassi.mmreborn.client.integration.emi.MMREmiClientIntegration;
import es.degrassi.mmreborn.client.integration.jei.MMRJeiClientIntegration;
import es.degrassi.mmreborn.client.item.MMRItemTooltip;
import es.degrassi.mmreborn.client.item.MMRItemTooltipComponent;
import es.degrassi.mmreborn.client.model.InitBuiltInModels;
import es.degrassi.mmreborn.client.model.controller.ControllerModelLoader;
import es.degrassi.mmreborn.client.model.hatch.HatchModelLoader;
import es.degrassi.mmreborn.client.screen.ControllerScreen;
import es.degrassi.mmreborn.client.screen.EnergyHatchScreen;
import es.degrassi.mmreborn.client.screen.ExperienceHatchScreen;
import es.degrassi.mmreborn.client.screen.FluidHatchScreen;
import es.degrassi.mmreborn.client.screen.FuelTankScreen;
import es.degrassi.mmreborn.client.screen.ItemBusScreen;
import es.degrassi.mmreborn.client.screen.ItemDurabilityScreen;
import es.degrassi.mmreborn.client.screen.ParallelHatchScreen;
import es.degrassi.mmreborn.client.screen.RedstonePortScreen;
import es.degrassi.mmreborn.common.block.BlockDynamicColor;
import es.degrassi.mmreborn.common.data.Config;
import es.degrassi.mmreborn.common.data.MMRConfig;
import es.degrassi.mmreborn.common.entity.DurabilityHatchEntity;
import es.degrassi.mmreborn.common.entity.FuelTankEntity;
import es.degrassi.mmreborn.common.entity.MachineControllerEntity;
import es.degrassi.mmreborn.common.entity.ParallelHatchEntity;
import es.degrassi.mmreborn.common.entity.RedstonePortEntity;
import es.degrassi.mmreborn.common.entity.base.ColorableMachineEntity;
import es.degrassi.mmreborn.common.entity.base.EnergyHatchEntity;
import es.degrassi.mmreborn.common.entity.base.ExperienceHatchEntity;
import es.degrassi.mmreborn.common.entity.base.FluidTankEntity;
import es.degrassi.mmreborn.common.entity.base.TileItemBus;
import es.degrassi.mmreborn.common.item.ItemDynamicColor;
import es.degrassi.mmreborn.common.registration.BlockRegistration;
import es.degrassi.mmreborn.common.registration.ContainerRegistration;
import es.degrassi.mmreborn.common.registration.EntityRegistration;
import es.degrassi.mmreborn.common.registration.ItemRegistration;
import es.degrassi.mmreborn.common.util.Mods;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod(value="modular_machinery_reborn", dist={Dist.CLIENT})
public class ModularMachineryRebornClient {
    public static final ClientScheduler clientScheduler = new ClientScheduler();
    private static Map<ModelResourceLocation, BakedModel> models;
    private static final List<Block> blockModelsToRegister;
    private static final List<Item> itemModelsToRegister;
    private final IEventBus bus;

    public ModularMachineryRebornClient(IEventBus bus) {
        MMRAthenaModels.init();
        InitBuiltInModels.init();
        NeoForge.EVENT_BUS.register((Object)clientScheduler);
        bus.register((Object)this);
        this.bus = bus;
    }

    @SubscribeEvent
    public void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(EntityRegistration.CONTROLLER.get(), ControllerRenderer::new);
        event.registerBlockEntityRenderer(EntityRegistration.STRUCTURE_CHECKER.get(), StructureCheckerRenderer::new);
    }

    @SubscribeEvent
    public void registerModelLoader(ModelEvent.RegisterGeometryLoaders event) {
        event.register(ModularMachineryReborn.rl("controller"), (IGeometryLoader)ControllerModelLoader.INSTANCE);
        event.register(ModularMachineryReborn.rl("hatch"), (IGeometryLoader)HatchModelLoader.INSTANCE);
    }

    @SubscribeEvent
    public void registerTooltip(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(MMRItemTooltipComponent.class, c -> new MMRItemTooltip(c.getItem(), c.getComponent(), c.isCompleted()));
    }

    @SubscribeEvent
    public void onBackingCompleted(ModelEvent.BakingCompleted event) {
        models = event.getModels();
    }

    public static Map<ModelResourceLocation, BakedModel> getAllModels() {
        return models;
    }

    public static boolean shouldAddParticles(RandomSource r) {
        return switch ((ParticleStatus)Minecraft.getInstance().options.particles().get()) {
            default -> throw new MatchException(null, null);
            case ParticleStatus.ALL -> true;
            case ParticleStatus.DECREASED -> r.nextBoolean();
            case ParticleStatus.MINIMAL -> false;
        };
    }

    public static void createParticle(ParticleOptions particle, BlockPos pos) {
        Minecraft.getInstance().particleEngine.createParticle(particle, (double)pos.getX(), (double)pos.getY() + 0.5, (double)pos.getZ(), 0.0, 0.0, 0.0);
    }

    @SubscribeEvent
    public void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        BlockRegistration.BLOCKS.getEntries().stream().map(DeferredHolder::value).filter(b -> b instanceof BlockDynamicColor).forEach(block -> event.register(ModularMachineryRebornClient::blockColor, new Block[]{block}));
        ModularMachineryReborn.MACHINES_BLOCK.values().forEach(block -> event.register(ModularMachineryRebornClient::blockColor, new Block[]{block}));
    }

    @SubscribeEvent
    public void registerItemColors(RegisterColorHandlersEvent.Item event) {
        ItemRegistration.ITEMS.getEntries().stream().map(DeferredHolder::value).filter(item -> item instanceof ItemDynamicColor).forEach(item -> event.register(ModularMachineryRebornClient::itemColor, new ItemLike[]{item}));
        ModularMachineryReborn.MACHINES_BLOCK.values().forEach(block -> event.register(ModularMachineryRebornClient::itemColor, new ItemLike[]{block}));
    }

    public static int blockColor(BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int tintIndex) {
        if (level == null || pos == null) {
            return 0;
        }
        switch (tintIndex) {
            case 1: {
                level.getBlockTint(pos, BiomeColors.WATER_COLOR_RESOLVER);
                break;
            }
            case 2: {
                level.getBlockTint(pos, BiomeColors.GRASS_COLOR_RESOLVER);
                break;
            }
            case 3: {
                level.getBlockTint(pos, BiomeColors.FOLIAGE_COLOR_RESOLVER);
                break;
            }
            case 4: {
                BlockEntity tile = level.getBlockEntity(pos);
                if (!(tile instanceof ColorableMachineEntity)) break;
                ColorableMachineEntity machineTile = (ColorableMachineEntity)tile;
                return machineTile.getMachineColor();
            }
        }
        return Config.machineColor;
    }

    public static int itemColor(ItemStack stack, int tintIndex) {
        Item item = stack.getItem();
        if (item instanceof ItemDynamicColor) {
            ItemDynamicColor colorableItem = (ItemDynamicColor)item;
            return colorableItem.getColorFromItemstack(stack, tintIndex);
        }
        return Config.machineColor;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onModelRegister(ModelEvent.RegisterAdditional event) {
        event.register(ModelResourceLocation.standalone((ResourceLocation)ModularMachineryReborn.rl("block/nope")));
        event.register(ModelResourceLocation.standalone((ResourceLocation)ModularMachineryReborn.rl("default/controller")));
        event.register(ModelResourceLocation.standalone((ResourceLocation)ModularMachineryReborn.rl("default/hatch_all")));
        event.register(ModelResourceLocation.standalone((ResourceLocation)ModularMachineryReborn.rl("default/hatch_orientable")));
        Minecraft.getInstance().getResourceManager().listResources("models/default/hatches", s -> s.getPath().endsWith(".json")).forEach((rl, resource) -> {
            ResourceLocation modelRL = ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)rl.getPath().substring(7).replace(".json", ""));
            event.register(ModelResourceLocation.standalone((ResourceLocation)modelRL));
        });
        for (String folder : (List)MMRConfig.get().modelFolders.get()) {
            Minecraft.getInstance().getResourceManager().listResources("models/" + folder, s -> s.getPath().endsWith(".json")).forEach((rl, resource) -> {
                ResourceLocation modelRL = ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)rl.getPath().substring(7).replace(".json", ""));
                event.register(ModelResourceLocation.standalone((ResourceLocation)modelRL));
            });
        }
        for (Block block : blockModelsToRegister) {
            event.register(ModelResourceLocation.standalone((ResourceLocation)Holder.direct((Object)block).getKey().location()));
            itemModelsToRegister.add(block.asItem());
        }
        for (Item item : itemModelsToRegister) {
            String name = item.getClass().getSimpleName().toLowerCase();
            if (item instanceof BlockItem) {
                name = ((BlockItem)item).getBlock().getClass().getSimpleName().toLowerCase();
            }
            event.register(new ModelResourceLocation(ModularMachineryReborn.rl(name), "inventory"));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent event) {
        if (Mods.isEMILoaded()) {
            new MMREmiClientIntegration(this.bus);
        } else if (Mods.isJEILoaded()) {
            new MMRJeiClientIntegration(this.bus);
        }
    }

    public void registerBlockModel(Block block) {
        blockModelsToRegister.add(block);
    }

    public void registerItemModel(Item item) {
        itemModelsToRegister.add(item);
    }

    @SubscribeEvent
    public void registerMenuScreens(RegisterMenuScreensEvent event) {
        event.register((MenuType)ContainerRegistration.CONTROLLER.get(), ControllerScreen::new);
        event.register((MenuType)ContainerRegistration.ENERGY_HATCH.get(), EnergyHatchScreen::new);
        event.register((MenuType)ContainerRegistration.FLUID_HATCH.get(), FluidHatchScreen::new);
        event.register((MenuType)ContainerRegistration.ITEM_BUS.get(), ItemBusScreen::new);
        event.register((MenuType)ContainerRegistration.ITEM_DURABILITY_HATCH.get(), ItemDurabilityScreen::new);
        event.register((MenuType)ContainerRegistration.EXPERIENCE_HATCH.get(), ExperienceHatchScreen::new);
        event.register((MenuType)ContainerRegistration.PARALLEL_HATCH.get(), ParallelHatchScreen::new);
        event.register((MenuType)ContainerRegistration.FUEL_TANK.get(), FuelTankScreen::new);
        event.register((MenuType)ContainerRegistration.REDSTONE_PORT.get(), RedstonePortScreen::new);
    }

    @NotNull
    public static MachineControllerEntity getClientSideMachineControllerEntity(BlockPos pos) {
        BlockEntity tile;
        if (Minecraft.getInstance().level != null && (tile = Minecraft.getInstance().level.getBlockEntity(pos)) instanceof MachineControllerEntity) {
            MachineControllerEntity controller = (MachineControllerEntity)tile;
            return controller;
        }
        throw new IllegalStateException("Trying to open a Controller container without clicking on a Controller block");
    }

    public static EnergyHatchEntity getClientSideEnergyHatchEntity(BlockPos pos) {
        BlockEntity tile;
        if (Minecraft.getInstance().level != null && (tile = Minecraft.getInstance().level.getBlockEntity(pos)) instanceof EnergyHatchEntity) {
            EnergyHatchEntity controller = (EnergyHatchEntity)tile;
            return controller;
        }
        throw new IllegalStateException("Trying to open a Energy Hatch container without clicking on a Energy Hatch block");
    }

    public static FluidTankEntity getClientSideFluidHatchEntity(BlockPos pos) {
        BlockEntity tile;
        if (Minecraft.getInstance().level != null && (tile = Minecraft.getInstance().level.getBlockEntity(pos)) instanceof FluidTankEntity) {
            FluidTankEntity controller = (FluidTankEntity)tile;
            return controller;
        }
        throw new IllegalStateException("Trying to open a Fluid Hatch container without clicking on a Fluid Hatch block");
    }

    public static TileItemBus getClientSideItemBusEntity(BlockPos pos) {
        BlockEntity tile;
        if (Minecraft.getInstance().level != null && (tile = Minecraft.getInstance().level.getBlockEntity(pos)) instanceof TileItemBus) {
            TileItemBus controller = (TileItemBus)tile;
            return controller;
        }
        throw new IllegalStateException("Trying to open a Item Bus container without clicking on a Item Bus block");
    }

    public static ExperienceHatchEntity getClientSideExperienceHatchEntity(BlockPos pos) {
        BlockEntity tile;
        if (Minecraft.getInstance().level != null && (tile = Minecraft.getInstance().level.getBlockEntity(pos)) instanceof ExperienceHatchEntity) {
            ExperienceHatchEntity controller = (ExperienceHatchEntity)tile;
            return controller;
        }
        throw new IllegalStateException("Trying to open a Experience Hatch container without clicking on a Experience Hatch block");
    }

    public static ParallelHatchEntity getClientSideParallelHatchEntity(BlockPos pos) {
        BlockEntity tile;
        if (Minecraft.getInstance().level != null && (tile = Minecraft.getInstance().level.getBlockEntity(pos)) instanceof ParallelHatchEntity) {
            ParallelHatchEntity controller = (ParallelHatchEntity)tile;
            return controller;
        }
        throw new IllegalStateException("Trying to open a Parallel Hatch container without clicking on a Parallel Hatch block");
    }

    public static DurabilityHatchEntity getClientSideItemDurabilityEntity(BlockPos pos) {
        BlockEntity tile;
        if (Minecraft.getInstance().level != null && (tile = Minecraft.getInstance().level.getBlockEntity(pos)) instanceof DurabilityHatchEntity) {
            DurabilityHatchEntity controller = (DurabilityHatchEntity)tile;
            return controller;
        }
        throw new IllegalStateException("Trying to open a Durability Hatch container without clicking on a Durability Hatch block");
    }

    public static FuelTankEntity getClientSideFuelTankEntity(BlockPos pos) {
        BlockEntity tile;
        if (Minecraft.getInstance().level != null && (tile = Minecraft.getInstance().level.getBlockEntity(pos)) instanceof FuelTankEntity) {
            FuelTankEntity controller = (FuelTankEntity)tile;
            return controller;
        }
        throw new IllegalStateException("Trying to open a Fuel Tank container without clicking on a Fuel Tank block");
    }

    public static RedstonePortEntity getClientSideRedstonePortEntity(BlockPos pos) {
        BlockEntity tile;
        if (Minecraft.getInstance().level != null && (tile = Minecraft.getInstance().level.getBlockEntity(pos)) instanceof RedstonePortEntity) {
            RedstonePortEntity controller = (RedstonePortEntity)tile;
            return controller;
        }
        throw new IllegalStateException("Trying to open a Redstone Port container without clicking on a Redstone Port block");
    }

    static {
        blockModelsToRegister = Lists.newLinkedList();
        itemModelsToRegister = Lists.newLinkedList();
    }
}

