/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.api.crafting.requirement;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.codec.DefaultCodecs;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.api.crafting.requirement.IDisplayInfo;
import es.degrassi.mmreborn.common.util.TextComponentUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class DisplayInfoTemplate {
    private static final ResourceLocation DEFAULT_TEXTURE = ModularMachineryReborn.rl("textures/gui/create_icon.png");
    public static final NamedCodec<Pair<Component, IDisplayInfo.TooltipPredicate>> TOOLTIPS = NamedCodec.either(NamedCodec.pair(TextComponentUtils.CODEC.fieldOf("text"), IDisplayInfo.TooltipPredicate.CODEC.fieldOf("predicate")), TextComponentUtils.CODEC).xmap(either -> (Pair)either.map(Function.identity(), component -> Pair.of((Object)component, (Object)IDisplayInfo.TooltipPredicate.ALWAYS)), Either::left, "Tooltips");
    public static final NamedCodec<DisplayInfoTemplate> CODEC = NamedCodec.record(displayInfoTemplateInstance -> displayInfoTemplateInstance.group(TOOLTIPS.listOf().optionalFieldOf("tooltips", Collections.emptyList()).forGetter(template -> template.tooltips), DefaultCodecs.ITEM_OR_STACK.optionalFieldOf("item").forGetter(template -> Optional.ofNullable(template.stack)), DefaultCodecs.RESOURCE_LOCATION.optionalFieldOf("icon", DEFAULT_TEXTURE).forGetter(template -> template.icon), NamedCodec.intRange(1, 128).optionalFieldOf("width", 10).forGetter(template -> template.width), NamedCodec.intRange(1, 128).optionalFieldOf("height", 10).forGetter(template -> template.height), NamedCodec.intRange(0, Integer.MAX_VALUE).optionalFieldOf("u", 0).forGetter(template -> template.u), NamedCodec.intRange(0, Integer.MAX_VALUE).optionalFieldOf("v", 0).forGetter(template -> template.v), DefaultCodecs.RESOURCE_LOCATION.optionalFieldOf("atlas").forGetter(template -> Optional.ofNullable(template.atlas)), DefaultCodecs.RESOURCE_LOCATION.optionalFieldOf("sprite").forGetter(template -> Optional.ofNullable(template.sprite))).apply((Applicative)displayInfoTemplateInstance, (tooltips, stack, icon, width, height, u, v, atlas, sprite) -> {
        DisplayInfoTemplate template = new DisplayInfoTemplate();
        tooltips.forEach(template::tooltip);
        stack.ifPresent(template::item);
        template.texture((ResourceLocation)icon, (int)width, (int)height, (int)u, (int)v);
        atlas.ifPresent(a -> sprite.ifPresent(s -> template.sprite((ResourceLocation)a, (ResourceLocation)s)));
        return template;
    }), "Display info template");
    public static final DisplayInfoTemplate EMPTY = new DisplayInfoTemplate();
    private final List<Pair<Component, IDisplayInfo.TooltipPredicate>> tooltips = new ArrayList<Pair<Component, IDisplayInfo.TooltipPredicate>>();
    @Nullable
    private ItemStack stack;
    private ResourceLocation icon = DEFAULT_TEXTURE;
    private int width = 10;
    private int height = 10;
    private int u = 0;
    private int v = 0;
    @Nullable
    private ResourceLocation atlas;
    @Nullable
    private ResourceLocation sprite;

    private DisplayInfoTemplate tooltip(Pair<Component, IDisplayInfo.TooltipPredicate> pair) {
        this.tooltips.add(pair);
        return this;
    }

    public DisplayInfoTemplate tooltip(Component component, IDisplayInfo.TooltipPredicate predicate) {
        return this.tooltip((Pair<Component, IDisplayInfo.TooltipPredicate>)Pair.of((Object)component, (Object)predicate));
    }

    public DisplayInfoTemplate tooltip(Component component) {
        return this.tooltip(component, IDisplayInfo.TooltipPredicate.ALWAYS);
    }

    public DisplayInfoTemplate item(ItemStack stack) {
        this.stack = stack;
        return this;
    }

    public DisplayInfoTemplate texture(ResourceLocation icon) {
        return this.texture(icon, 16, 16);
    }

    public DisplayInfoTemplate texture(ResourceLocation icon, int width, int height) {
        return this.texture(icon, width, height, 0, 0);
    }

    public DisplayInfoTemplate texture(ResourceLocation icon, int width, int height, int u, int v) {
        this.icon = icon;
        this.width = width;
        this.height = height;
        this.u = u;
        this.v = v;
        return this;
    }

    public DisplayInfoTemplate sprite(ResourceLocation atlas, ResourceLocation sprite) {
        this.atlas = atlas;
        this.sprite = sprite;
        return this;
    }

    public void build(IDisplayInfo info) {
        this.tooltips.forEach(pair -> info.addTooltip((Component)pair.getFirst(), (IDisplayInfo.TooltipPredicate)pair.getSecond()));
        if (this.stack != null) {
            info.setItemIcon(this.stack);
        } else if (this.atlas != null && this.sprite != null) {
            info.setSpriteIcon(this.atlas, this.sprite);
        } else {
            info.setTextureIcon(this.icon, this.width, this.height, this.u, this.v);
        }
    }

    @Generated
    public List<Pair<Component, IDisplayInfo.TooltipPredicate>> getTooltips() {
        return this.tooltips;
    }
}

