/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.api.controller;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.api.controller.IMultiblockController;
import es.degrassi.mmreborn.common.entity.MachineControllerEntity;
import es.degrassi.mmreborn.common.util.MMRLogger;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class MMRWorldSavedData
extends SavedData {
    public final Map<BlockPos, IMultiblockController> mapping;
    public final Map<ChunkPos, Set<IMultiblockController>> chunkPosMapping;
    private final CopyOnWriteArrayList<IMultiblockController> controllers = new CopyOnWriteArrayList();
    private ScheduledExecutorService executorService;
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactoryBuilder().setNameFormat("MMR Multiblock Async Thread-%d").setDaemon(true).build();
    private static final ThreadLocal<Boolean> IN_SERVICE = ThreadLocal.withInitial(() -> false);
    private long periodID = Long.MIN_VALUE;

    public static MMRWorldSavedData getOrCreate(ServerLevel level) {
        return (MMRWorldSavedData)level.getDataStorage().computeIfAbsent(new SavedData.Factory(MMRWorldSavedData::new, MMRWorldSavedData::new), "mmr_multiblocks");
    }

    private MMRWorldSavedData() {
        this.mapping = new Object2ObjectOpenHashMap();
        this.chunkPosMapping = new HashMap<ChunkPos, Set<IMultiblockController>>();
    }

    private MMRWorldSavedData(CompoundTag tag, HolderLookup.Provider provider) {
        this();
    }

    public Set<IMultiblockController> getControllersInChunk(ChunkPos chunkPos) {
        return this.chunkPosMapping.getOrDefault(chunkPos, Collections.emptySet());
    }

    public void addMapping(IMultiblockController machine) {
        this.mapping.put(machine.getBlockPos(), machine);
        for (BlockPos relative : machine.getController().getPattern().getPattern().get(machine.getFacing()).keySet()) {
            BlockPos pos = machine.getBlockPos().offset((Vec3i)relative);
            this.chunkPosMapping.computeIfAbsent(new ChunkPos(pos), c -> new HashSet()).add(machine);
        }
    }

    public void removeMapping(IMultiblockController machine) {
        IMultiblockController prev = this.mapping.remove(machine.getBlockPos());
        if (prev == null) {
            return;
        }
        for (BlockPos relative : machine.getController().getPattern().getPattern().get(machine.getFacing()).keySet()) {
            BlockPos pos = machine.getBlockPos().offset((Vec3i)relative);
            ChunkPos cPos = new ChunkPos(pos);
            Set<IMultiblockController> set = this.chunkPosMapping.get(cPos);
            if (set == null) continue;
            set.remove(machine);
            this.chunkPosMapping.put(cPos, set);
        }
    }

    @NotNull
    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
        return compoundTag;
    }

    public void createExecutorService() {
        if (this.executorService != null && !this.executorService.isShutdown()) {
            return;
        }
        this.executorService = Executors.newSingleThreadScheduledExecutor(THREAD_FACTORY);
        this.executorService.scheduleAtFixedRate(this::searchingTask, 0L, 250L, TimeUnit.MILLISECONDS);
    }

    public void addAsyncLogic(IMultiblockController controller) {
        this.controllers.add(controller);
        this.createExecutorService();
    }

    public void removeAsyncLogic(IMultiblockController controller) {
        if (this.controllers.contains(controller)) {
            this.controllers.remove(controller);
            if (this.controllers.isEmpty()) {
                this.releaseExecutorService();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchingTask() {
        try {
            if (!ModularMachineryReborn.canGetServerLevel()) {
                return;
            }
            IN_SERVICE.set(true);
            for (IMultiblockController controller : this.controllers) {
                try {
                    controller.asyncCheckPattern(this.periodID);
                }
                catch (Throwable e) {
                    MMRLogger.INSTANCE.error("Error while assembling multiblock {}", (Object)controller.getId(), (Object)e);
                }
            }
        }
        catch (Throwable e) {
            MMRLogger.INSTANCE.error("Error while assembling multiblocks", e);
        }
        finally {
            IN_SERVICE.set(false);
        }
        ++this.periodID;
    }

    public static boolean isThreadService() {
        return IN_SERVICE.get() != false && ModularMachineryReborn.canGetServerLevel();
    }

    public void releaseExecutorService() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
        this.executorService = null;
    }

    public boolean containsAsyncLogicOrMapping(MachineControllerEntity machineControllerEntity) {
        return this.controllers.contains(machineControllerEntity) || this.mapping.containsValue(machineControllerEntity);
    }

    @Generated
    public long getPeriodID() {
        return this.periodID;
    }
}

