/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.api.client;

import es.degrassi.mmreborn.api.client.Icon;
import java.util.List;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;

public enum ExperienceButtonType implements StringRepresentable
{
    EXTRACT_1(Icon.XP_EXTRACT_1),
    EXTRACT_10(Icon.XP_EXTRACT_10),
    EXTRACT_ALL(Icon.XP_EXTRACT_100),
    INSERT_1(Icon.XP_INSERT_1),
    INSERT_10(Icon.XP_INSERT_10),
    INSERT_ALL(Icon.XP_INSERT_100);

    private final Icon icon;

    private ExperienceButtonType(Icon icon) {
        this.icon = icon;
    }

    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public boolean isAll() {
        return this == EXTRACT_ALL || this == INSERT_ALL;
    }

    public boolean extract() {
        return switch (this.ordinal()) {
            case 0, 1, 2 -> true;
            default -> false;
        };
    }

    public static List<ExperienceButtonType> extractions() {
        return List.of(EXTRACT_1, EXTRACT_10, EXTRACT_ALL);
    }

    public static List<ExperienceButtonType> insertions() {
        return List.of(INSERT_1, INSERT_10, INSERT_ALL);
    }

    public Icon icon() {
        return this.icon;
    }

    public int getAmount(boolean extraction) {
        return switch (this.ordinal()) {
            case 0, 3 -> {
                if (extraction) {
                    yield 1;
                }
                yield -1;
            }
            case 1, 4 -> {
                if (extraction) {
                    yield 10;
                }
                yield -10;
            }
            default -> 0;
        };
    }

    public Component component() {
        return Component.translatable((String)("mmr.gui.tooltip.experience.button." + this.getSerializedName()));
    }
}

