/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.api.capability;

import com.google.common.base.Suppliers;
import es.degrassi.mmreborn.common.entity.base.EntityBaseEntity;
import es.degrassi.mmreborn.common.util.MMRDamageSource;
import es.degrassi.mmreborn.common.util.Utils;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.phys.AABB;

public class EntityHandler {
    private final Supplier<MMRDamageSource> damageSource = Suppliers.memoize(() -> new MMRDamageSource(entity.getController(), entity));
    private final EntityBaseEntity delegate;

    public EntityHandler(EntityBaseEntity entity) {
        this.delegate = entity;
    }

    public int getEntitiesInRadius(int radius, Predicate<Entity> filter) {
        BlockPos pos = this.delegate.getBlockPos();
        AABB bb = new AABB((double)(pos.getX() - radius), (double)(pos.getY() - radius), (double)(pos.getZ() - radius), (double)(pos.getX() + radius), (double)(pos.getY() + radius), (double)(pos.getZ() + radius));
        return this.delegate.getLevel().getEntitiesOfClass(Entity.class, bb, entity -> entity.distanceToSqr(Utils.vec3dFromBlockPos(pos)) <= (double)(radius * radius) && filter.test((Entity)entity)).size();
    }

    public double getEntitiesInRadiusHealth(int radius, Predicate<Entity> filter) {
        BlockPos pos = this.delegate.getBlockPos();
        AABB bb = new AABB((double)(pos.getX() - radius), (double)(pos.getY() - radius), (double)(pos.getZ() - radius), (double)(pos.getX() + radius), (double)(pos.getY() + radius), (double)(pos.getZ() + radius));
        return this.delegate.getLevel().getEntitiesOfClass(LivingEntity.class, bb, entity -> filter.test((Entity)entity) && entity.distanceToSqr(Utils.vec3dFromBlockPos(pos)) <= (double)(radius * radius)).stream().mapToDouble(LivingEntity::getHealth).sum();
    }

    public boolean canHealEntitiesInRadius(int radius, Predicate<Entity> filter, int amount) {
        BlockPos pos = this.delegate.getBlockPos();
        AABB bb = new AABB((double)(pos.getX() - radius), (double)(pos.getY() - radius), (double)(pos.getZ() - radius), (double)(pos.getX() + radius), (double)(pos.getY() + radius), (double)(pos.getZ() + radius));
        return this.delegate.getLevel().getEntitiesOfClass(LivingEntity.class, bb, entity -> filter.test((Entity)entity) && entity.distanceToSqr(Utils.vec3dFromBlockPos(pos)) <= (double)(radius * radius)).stream().mapToDouble(entity -> entity.getMaxHealth() - entity.getHealth()).sum() >= (double)amount;
    }

    public boolean canHurtEntitiesInRadius(int radius, Predicate<Entity> filter, int amount) {
        BlockPos pos = this.delegate.getBlockPos();
        AABB bb = new AABB((double)(pos.getX() - radius), (double)(pos.getY() - radius), (double)(pos.getZ() - radius), (double)(pos.getX() + radius), (double)(pos.getY() + radius), (double)(pos.getZ() + radius));
        return this.delegate.getLevel().getEntitiesOfClass(LivingEntity.class, bb, entity -> filter.test((Entity)entity) && entity.distanceToSqr(Utils.vec3dFromBlockPos(pos)) <= (double)(radius * radius)).stream().mapToDouble(LivingEntity::getHealth).sum() >= (double)amount;
    }

    public void removeEntitiesHealth(int radius, Predicate<Entity> filter, int amount) {
        BlockPos pos = this.delegate.getBlockPos();
        AtomicInteger toRemove = new AtomicInteger(amount);
        AABB bb = new AABB((double)(pos.getX() - radius), (double)(pos.getY() - radius), (double)(pos.getZ() - radius), (double)(pos.getX() + radius), (double)(pos.getY() + radius), (double)(pos.getZ() + radius));
        this.delegate.getLevel().getEntitiesOfClass(LivingEntity.class, bb, entity -> filter.test((Entity)entity) && entity.distanceToSqr(Utils.vec3dFromBlockPos(pos)) <= (double)(radius * radius)).forEach(entity -> {
            int maxRemove = Math.min((int)entity.getHealth(), toRemove.get());
            entity.hurt((DamageSource)this.damageSource.get(), (float)maxRemove);
            toRemove.addAndGet(-maxRemove);
        });
    }

    public void addEntitiesHealth(int radius, Predicate<Entity> filter, int amount) {
        BlockPos pos = this.delegate.getBlockPos();
        AtomicReference<Float> toAdd = new AtomicReference<Float>(Float.valueOf((float)amount * 1.0f));
        AABB bb = new AABB((double)(pos.getX() - radius), (double)(pos.getY() - radius), (double)(pos.getZ() - radius), (double)(pos.getX() + radius), (double)(pos.getY() + radius), (double)(pos.getZ() + radius));
        this.delegate.getLevel().getEntitiesOfClass(LivingEntity.class, bb, entity -> filter.test((Entity)entity) && entity.distanceToSqr(Utils.vec3dFromBlockPos(pos)) <= (double)(radius * radius)).forEach(entity -> {
            float maxAdd = Math.min(entity.getMaxHealth() - entity.getHealth(), ((Float)toAdd.get()).floatValue());
            entity.heal(maxAdd);
            toAdd.set(Float.valueOf(((Float)toAdd.get()).floatValue() - maxAdd));
        });
    }

    public void killEntities(int radius, Predicate<Entity> filter, int amount) {
        BlockPos pos = this.delegate.getBlockPos();
        AABB bb = new AABB((double)(pos.getX() - radius), (double)(pos.getY() - radius), (double)(pos.getZ() - radius), (double)(pos.getX() + radius), (double)(pos.getY() + radius), (double)(pos.getZ() + radius));
        this.delegate.getLevel().getEntitiesOfClass(LivingEntity.class, bb, entity -> filter.test((Entity)entity) && entity.distanceToSqr(Utils.vec3dFromBlockPos(pos)) <= (double)(radius * radius)).stream().limit(amount).forEach(entity -> entity.hurt((DamageSource)this.damageSource.get(), Float.MAX_VALUE));
    }

    public boolean spawnEntities(int radius, int amount, EntityType<?> type) {
        BlockPos pos = this.delegate.getBlockPos();
        RandomSource rand = this.delegate.getLevel().random;
        AABB bb = new AABB((double)(pos.getX() - radius), (double)(pos.getY() - radius), (double)(pos.getZ() - radius), (double)(pos.getX() + radius), (double)(pos.getY() + radius), (double)(pos.getZ() + radius));
        for (int i = 0; i < amount; ++i) {
            int x = rand.nextIntBetweenInclusive((int)bb.minX, (int)bb.maxX);
            int y = rand.nextIntBetweenInclusive((int)bb.minY, (int)bb.maxY);
            int z = rand.nextIntBetweenInclusive((int)bb.minZ, (int)bb.maxZ);
            BlockPos toSpawnPos = new BlockPos(x, y, z);
            if (!this.delegate.getLevel().getBlockState(toSpawnPos).isAir()) {
                --i;
                continue;
            }
            type.spawn((ServerLevel)this.delegate.getLevel(), toSpawnPos, MobSpawnType.SPAWNER);
        }
        return true;
    }
}

