/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.api.capability;

import es.degrassi.mmreborn.common.block.prop.EffectDispenserSize;
import es.degrassi.mmreborn.common.entity.EffectDispenserEntity;
import es.degrassi.mmreborn.common.network.server.component.SUpdateEffectComponent;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.network.PacketDistributor;

public class EffectHandler {
    private final EffectDispenserEntity entity;
    private boolean isApplyingEffect = false;
    private MobEffectInstance effect;

    public EffectHandler(EffectDispenserEntity entity) {
        this.entity = entity;
    }

    private EffectDispenserSize getSize() {
        return this.entity.getSize();
    }

    public void setData(Optional<MobEffectInstance> effect) {
        effect.ifPresentOrElse(ef -> {
            this.effect = ef;
            this.isApplyingEffect = true;
        }, () -> {
            this.isApplyingEffect = false;
            this.effect = null;
        });
    }

    public void applyEffect(MobEffectInstance effect, Predicate<Entity> filter) {
        this.setData(Optional.of(effect));
        if (this.getSize().interdimensional) {
            Stream.Builder levels = Stream.builder();
            this.entity.getLevel().getServer().getAllLevels().forEach(levels::add);
            levels.build().map(level -> {
                WorldBorder worldBorder = level.getWorldBorder();
                AABB worldBB = new AABB(worldBorder.getMinX(), (double)level.getMinBuildHeight(), worldBorder.getMinZ(), worldBorder.getMaxX(), (double)level.getMaxBuildHeight(), worldBorder.getMaxZ());
                return level.getEntitiesOfClass(LivingEntity.class, worldBB, filter);
            }).flatMap(Collection::stream).forEach(entity -> entity.addEffect(effect));
            this.setChanged();
            return;
        }
        BlockPos machinePos = this.entity.getBlockPos();
        AABB bb = new AABB(machinePos).inflate((double)this.getSize().radius);
        this.entity.getLevel().getEntitiesOfClass(LivingEntity.class, bb, filter).stream().filter(entity -> entity.distanceToSqr((double)machinePos.getX(), (double)machinePos.getY(), (double)machinePos.getZ()) < (double)(this.getSize().radius * this.getSize().radius)).forEach(entity -> entity.addEffect(effect));
        this.setChanged();
    }

    public void resetEffect() {
        this.setData(Optional.empty());
        this.setChanged();
    }

    public void setChanged() {
        this.entity.setChanged();
        Level level = this.entity.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)sl, (ChunkPos)new ChunkPos(this.entity.getBlockPos()), (CustomPacketPayload)new SUpdateEffectComponent(Optional.ofNullable(this.effect), this.entity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Generated
    public boolean isApplyingEffect() {
        return this.isApplyingEffect;
    }

    @Generated
    public void setApplyingEffect(boolean isApplyingEffect) {
        this.isApplyingEffect = isApplyingEffect;
    }

    @Generated
    public MobEffectInstance getEffect() {
        return this.effect;
    }

    @Generated
    public void setEffect(MobEffectInstance effect) {
        this.effect = effect;
    }
}

