/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.api.capability;

import es.degrassi.experiencelib.api.capability.IContentsListener;
import es.degrassi.mmreborn.api.capability.IFuelHandler;
import es.degrassi.mmreborn.common.util.IOInventory;
import es.degrassi.mmreborn.common.util.ItemSlot;
import lombok.Generated;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;

public class BasicFuelHandler
implements IFuelHandler {
    private long fuel;
    private long maxFuel;
    private final IOInventory inventory;
    private IContentsListener listener;

    public BasicFuelHandler(IOInventory inventory) {
        this.inventory = inventory;
    }

    @Override
    public void addFuel(long fuel) {
        if (this.fuel >= this.maxFuel) {
            return;
        }
        this.fuel += fuel;
        this.setChanged();
    }

    @Override
    public void removeFuel(long fuel) {
        if (this.fuel < fuel) {
            return;
        }
        this.fuel -= fuel;
        this.setChanged();
    }

    @Override
    public boolean burn(long amount) {
        if (this.fuel >= amount) {
            this.removeFuel(amount);
            return true;
        }
        return false;
    }

    @Override
    public void tryBurnItem() {
        this.inventory.getInventory().stream().filter(ItemSlot::isInput).filter(slot -> !slot.getItemStack().isEmpty()).filter(slot -> slot.getItemStack().getBurnTime(RecipeType.SMELTING) > 0).findFirst().ifPresent(slot -> {
            long fuel = slot.getItemStack().getBurnTime(RecipeType.SMELTING);
            if (!this.hasSpace(fuel)) {
                return;
            }
            this.addFuel(fuel);
            ItemStack stack = slot.getItemStack();
            if (stack.hasCraftingRemainingItem()) {
                slot.setItemStack(stack.getCraftingRemainingItem());
            } else {
                slot.extractItemBypassLimit(1, false);
            }
            slot.setChanged();
        });
    }

    @Override
    public boolean hasSpace(long amount) {
        return this.fuel + amount <= this.maxFuel;
    }

    @Override
    public void setChanged() {
        if (this.listener != null) {
            this.listener.onContentsChanged();
        }
    }

    @Override
    @Generated
    public long getFuel() {
        return this.fuel;
    }

    @Override
    @Generated
    public long getMaxFuel() {
        return this.maxFuel;
    }

    @Override
    @Generated
    public IOInventory getInventory() {
        return this.inventory;
    }

    @Generated
    public IContentsListener getListener() {
        return this.listener;
    }

    @Override
    @Generated
    public void setFuel(long fuel) {
        this.fuel = fuel;
    }

    @Override
    @Generated
    public void setMaxFuel(long maxFuel) {
        this.maxFuel = maxFuel;
    }

    @Override
    @Generated
    public void setListener(IContentsListener listener) {
        this.listener = listener;
    }
}

