/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import es.degrassi.mmreborn.api.BlockIngredient;
import es.degrassi.mmreborn.api.MinBlocksPredicate;
import es.degrassi.mmreborn.api.PartialBlockState;
import es.degrassi.mmreborn.common.crafting.modifier.ModifierReplacement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;

public class Pattern {
    private final List<List<String>> strings;
    private final Map<Character, BlockIngredient> keys;
    private final Map<BlockPos, BlockIngredient> pattern;
    private final Map<BlockPos, BlockIngredient> pattern_north;
    private final Map<BlockPos, BlockIngredient> pattern_south;
    private final Map<BlockPos, BlockIngredient> pattern_east;
    private final Map<BlockPos, BlockIngredient> pattern_west;
    private final List<ModifierReplacement> modifiers;
    private final Map<BlockPos, List<ModifierReplacement>> modifiers_north;
    private final Map<BlockPos, List<ModifierReplacement>> modifiers_south;
    private final Map<BlockPos, List<ModifierReplacement>> modifiers_east;
    private final Map<BlockPos, List<ModifierReplacement>> modifiers_west;

    public Pattern(Map<BlockPos, BlockIngredient> pattern, List<List<String>> strings, Map<Character, BlockIngredient> keys) {
        this.pattern = pattern;
        this.strings = strings;
        this.keys = keys;
        this.pattern_north = this.rotate(Rotation.NONE);
        this.pattern_south = this.rotate(Rotation.CLOCKWISE_180);
        this.pattern_west = this.rotate(Rotation.COUNTERCLOCKWISE_90);
        this.pattern_east = this.rotate(Rotation.CLOCKWISE_90);
        this.modifiers = Lists.newArrayList();
        this.modifiers_north = Maps.newHashMap();
        this.modifiers_south = Maps.newHashMap();
        this.modifiers_east = Maps.newHashMap();
        this.modifiers_west = Maps.newHashMap();
    }

    public Pattern(Map<BlockPos, BlockIngredient> pattern, List<List<String>> strings, Map<Character, BlockIngredient> keys, List<ModifierReplacement> modifiers) {
        this.pattern = pattern;
        this.strings = strings;
        this.keys = keys;
        this.pattern_north = this.rotate(Rotation.NONE);
        this.pattern_south = this.rotate(Rotation.CLOCKWISE_180);
        this.pattern_west = this.rotate(Rotation.COUNTERCLOCKWISE_90);
        this.pattern_east = this.rotate(Rotation.CLOCKWISE_90);
        this.modifiers = modifiers;
        this.modifiers_north = this.rotateModifiers(Rotation.NONE);
        this.modifiers_south = this.rotateModifiers(Rotation.CLOCKWISE_180);
        this.modifiers_west = this.rotateModifiers(Rotation.COUNTERCLOCKWISE_90);
        this.modifiers_east = this.rotateModifiers(Rotation.CLOCKWISE_90);
        this.modifiers_north.forEach((pos, modifierList) -> modifierList.forEach(modifier -> this.pattern_north.put((BlockPos)pos, modifier.getIngredient().copyWithRotation(Rotation.NONE).merge(this.pattern_north.get(pos)))));
        this.modifiers_south.forEach((pos, modifierList) -> modifierList.forEach(modifier -> this.pattern_south.put((BlockPos)pos, modifier.getIngredient().copyWithRotation(Rotation.CLOCKWISE_180).merge(this.pattern_south.get(pos)))));
        this.modifiers_west.forEach((pos, modifierList) -> modifierList.forEach(modifier -> this.pattern_west.put((BlockPos)pos, modifier.getIngredient().copyWithRotation(Rotation.COUNTERCLOCKWISE_90).merge(this.pattern_west.get(pos)))));
        this.modifiers_east.forEach((pos, modifierList) -> modifierList.forEach(modifier -> this.pattern_east.put((BlockPos)pos, modifier.getIngredient().copyWithRotation(Rotation.CLOCKWISE_90).merge(this.pattern_east.get(pos)))));
    }

    public Map<BlockPos, BlockIngredient> get(Direction direction) {
        return switch (direction) {
            case Direction.WEST -> this.pattern_west;
            case Direction.EAST -> this.pattern_east;
            case Direction.SOUTH -> this.pattern_south;
            default -> this.pattern_north;
        };
    }

    private Rotation fromDirection(Direction direction) {
        return switch (direction) {
            case Direction.EAST -> Rotation.CLOCKWISE_90;
            case Direction.WEST -> Rotation.COUNTERCLOCKWISE_90;
            case Direction.SOUTH -> Rotation.CLOCKWISE_180;
            default -> Rotation.NONE;
        };
    }

    public Map<BlockPos, BlockIngredient> getFiltered(Direction direction) {
        return this.rotate(this.fromDirection(direction));
    }

    public Map<BlockPos, List<ModifierReplacement>> getModifiers(Direction direction) {
        return switch (direction) {
            case Direction.WEST -> this.modifiers_west;
            case Direction.EAST -> this.modifiers_east;
            case Direction.SOUTH -> this.modifiers_south;
            default -> this.modifiers_north;
        };
    }

    public Map<BlockPos, List<ModifierReplacement>> rotateModifiers(Rotation rotation) {
        HashMap map = Maps.newHashMap();
        this.modifiers.forEach(modifier -> map.computeIfAbsent(modifier.getPosition().rotate(rotation), key -> Lists.newArrayList()).add(modifier));
        return map;
    }

    private Map<BlockPos, BlockIngredient> rotate(Rotation rotation) {
        HashMap rotated = Maps.newHashMap();
        this.pattern.forEach((pos, ingredient) -> rotated.put(pos.rotate(rotation), ingredient.copyWithRotation(rotation)));
        return rotated;
    }

    public List<List<String>> asList() {
        return this.strings;
    }

    public Map<Character, BlockIngredient> asMap() {
        return this.keys;
    }

    public boolean match(LevelReader world, BlockPos machinePos, Direction machineFacing, MinBlocksPredicate predicate) {
        Map<BlockPos, BlockIngredient> blocks = this.get(machineFacing);
        BlockPos.MutableBlockPos worldPos = new BlockPos.MutableBlockPos();
        for (BlockPos pos : blocks.keySet()) {
            BlockIngredient ingredient = blocks.get(pos);
            worldPos.set(pos.getX() + machinePos.getX(), pos.getY() + machinePos.getY(), pos.getZ() + machinePos.getZ());
            BlockInWorld info = new BlockInWorld(world, (BlockPos)worldPos, false);
            if (predicate.test(ingredient, info)) continue;
            return false;
        }
        AtomicBoolean result = new AtomicBoolean(true);
        predicate.getTests().forEach((ing, found) -> {
            MinBlocksPredicate.MinMax minmax = predicate.minBlocks().get(ing);
            if (!minmax.test((Integer)found)) {
                result.set(false);
                predicate.getErrors().add(minmax.errorMessage((int)found, (Component)ing.getNamesUnified()));
            }
        });
        return result.get();
    }

    public JsonObject asJson() {
        JsonObject json = new JsonObject();
        JsonArray keysList = new JsonArray();
        this.strings.forEach(list -> {
            JsonArray keyKeyList = new JsonArray();
            list.forEach(arg_0 -> ((JsonArray)keyKeyList).add(arg_0));
            keysList.add((JsonElement)keyKeyList);
        });
        json.add("strings", (JsonElement)keysList);
        JsonObject keys = new JsonObject();
        this.keys.forEach((key, ingredient) -> {
            List<PartialBlockState> all = ingredient.getAll();
            JsonArray states = new JsonArray();
            all.forEach(state -> states.add(state.toString()));
            keys.add("" + key, (JsonElement)states);
        });
        json.add("keys", (JsonElement)keys);
        JsonObject pattern = new JsonObject();
        this.pattern.forEach((pos, ingredient) -> {
            List<PartialBlockState> all = ingredient.getAll();
            JsonArray states = new JsonArray();
            all.forEach(state -> states.add(state.toString()));
            pattern.add(pos.toString(), (JsonElement)states);
        });
        json.add("pattern", (JsonElement)pattern);
        JsonObject pattern_north = new JsonObject();
        this.pattern_north.forEach((pos, ingredient) -> {
            List<PartialBlockState> all = ingredient.getAll();
            JsonArray states = new JsonArray();
            all.forEach(state -> states.add(state.toString()));
            pattern_north.add(pos.toString(), (JsonElement)states);
        });
        json.add("pattern_north", (JsonElement)pattern_north);
        JsonObject pattern_south = new JsonObject();
        this.pattern_south.forEach((pos, ingredient) -> {
            List<PartialBlockState> all = ingredient.getAll();
            JsonArray states = new JsonArray();
            all.forEach(state -> states.add(state.toString()));
            pattern_south.add(pos.toString(), (JsonElement)states);
        });
        json.add("pattern_south", (JsonElement)pattern_south);
        JsonObject pattern_east = new JsonObject();
        this.pattern_east.forEach((pos, ingredient) -> {
            List<PartialBlockState> all = ingredient.getAll();
            JsonArray states = new JsonArray();
            all.forEach(state -> states.add(state.toString()));
            pattern_east.add(pos.toString(), (JsonElement)states);
        });
        json.add("pattern_east", (JsonElement)pattern_east);
        JsonObject pattern_west = new JsonObject();
        this.pattern_west.forEach((pos, ingredient) -> {
            List<PartialBlockState> all = ingredient.getAll();
            JsonArray states = new JsonArray();
            all.forEach(state -> states.add(state.toString()));
            pattern_west.add(pos.toString(), (JsonElement)states);
        });
        json.add("pattern_west", (JsonElement)pattern_west);
        return json;
    }

    public String toString() {
        return this.asJson().toString();
    }

    @Generated
    public List<ModifierReplacement> getModifiers() {
        return this.modifiers;
    }
}

