/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.api;

import com.google.common.collect.Maps;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import es.degrassi.mmreborn.api.BlockIngredient;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;

public final class MinBlocksPredicate
implements BiPredicate<BlockIngredient, BlockInWorld> {
    public static final NamedCodec<MinBlocksPredicate> CODEC = NamedCodec.unboundedMap(NamedCodec.STRING, MinMax.CODEC, "Map<String, MinMax>").comapFlatMap(map -> DataResult.success((Object)new MinBlocksPredicate((Map<String, MinMax>)map)), MinBlocksPredicate::originals, "MinBlocksPredicate");
    public static final MinBlocksPredicate EMPTY = new MinBlocksPredicate(Maps.newHashMap());
    private final Map<BlockIngredient, MinMax> minBlocks;
    private final Map<String, MinMax> originals;
    private final Object2IntOpenHashMap<BlockIngredient> tests = new Object2IntOpenHashMap();
    private final List<Component> errors = new ArrayList<Component>();

    public MinBlocksPredicate(Map<String, MinMax> minBlocks) {
        this.minBlocks = Maps.newHashMap();
        minBlocks.forEach((id, minmax) -> {
            try {
                BlockIngredient bi = BlockIngredient.of(id);
                this.minBlocks.put(bi, (MinMax)minmax);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.originals = minBlocks;
        this.tests.defaultReturnValue(0);
    }

    private Map<String, MinMax> originals() {
        return this.originals;
    }

    public Map<BlockIngredient, MinMax> minBlocks() {
        return this.minBlocks;
    }

    public void reset() {
        this.tests.replaceAll((b, i) -> 0);
        this.errors.clear();
    }

    private Optional<Component> compute(BlockInWorld block) {
        for (Map.Entry<BlockIngredient, MinMax> entry : this.minBlocks.entrySet()) {
            BlockIngredient key = entry.getKey();
            MinMax value = entry.getValue();
            if (!key.test(block)) continue;
            this.tests.addTo((Object)key, 1);
            int found = this.tests.getInt((Object)key);
            if (!value.test(found)) {
                return Optional.of(value.errorMessage(found, (Component)key.getNamesUnified()));
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    @Override
    public boolean test(BlockIngredient blockIngredient, BlockInWorld blockInWorld) {
        if (!blockIngredient.test(blockInWorld)) {
            return false;
        }
        return this.compute(blockInWorld).map(pair -> {
            this.errors.add((Component)pair);
            return false;
        }).orElse(true);
    }

    public JsonElement asJson() {
        JsonObject json = new JsonObject();
        this.originals.forEach((block, minmax) -> json.add(block, (JsonElement)minmax.toJson()));
        return json;
    }

    public String toString() {
        JsonObject json = new JsonObject();
        this.minBlocks.forEach((block, number) -> {
            String string = block.getString();
            JsonObject object = number.toJson();
            object.addProperty("test", (Number)this.tests.getInt(block));
            json.add(string, (JsonElement)object);
        });
        return new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json);
    }

    @Generated
    public Object2IntOpenHashMap<BlockIngredient> getTests() {
        return this.tests;
    }

    @Generated
    public List<Component> getErrors() {
        return this.errors;
    }

    public record MinMax(int min, int max) implements Predicate<Integer>
    {
        private static final int minValue = 0;
        private static final int maxValue = Integer.MAX_VALUE;
        public static final NamedCodec<MinMax> CODEC = NamedCodec.record(instance -> instance.group(NamedCodec.intRange(0, Integer.MAX_VALUE).optionalFieldOf("min", 0).forGetter(MinMax::min), NamedCodec.intRange(0, Integer.MAX_VALUE).optionalFieldOf("max", Integer.MAX_VALUE).forGetter(MinMax::max)).apply((Applicative)instance, MinMax::new), "MinMax");

        public static MinMax max(int max) {
            return new MinMax(0, max);
        }

        public static MinMax min(int min) {
            return new MinMax(min, Integer.MAX_VALUE);
        }

        @Override
        public boolean test(Integer toTest) {
            return this.min <= toTest && toTest <= this.max;
        }

        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("min", (Number)this.min);
            json.addProperty("max", (Number)this.max);
            return json;
        }

        public MutableComponent guiText() {
            if (this.min == 0 && this.max == Integer.MAX_VALUE) {
                return Component.empty();
            }
            if (this.min == this.max) {
                return Component.translatable((String)"mmr.controller.exactly", (Object[])new Object[]{this.min});
            }
            if (this.min == 0) {
                return Component.translatable((String)"mmr.controller.max", (Object[])new Object[]{this.max});
            }
            if (this.max == Integer.MAX_VALUE) {
                return Component.translatable((String)"mmr.controller.min", (Object[])new Object[]{this.min});
            }
            return Component.translatable((String)"mmr.controller.min_max", (Object[])new Object[]{this.min, this.max});
        }

        public Component errorMessage(int found, Component args) {
            if (this.min == this.max) {
                return Component.translatable((String)"mmr.structure.error.exact", (Object[])new Object[]{this.min, found, args});
            }
            if (this.min == 0) {
                return Component.translatable((String)"mmr.structure.error.max", (Object[])new Object[]{this.max, found, args});
            }
            if (this.max == Integer.MAX_VALUE) {
                return Component.translatable((String)"mmr.structure.error.min", (Object[])new Object[]{this.min, found, args});
            }
            return Component.translatable((String)"mmr.structure.error.between", (Object[])new Object[]{this.min, this.max, found, args});
        }
    }
}

