/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.api;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DataResult;
import es.degrassi.mmreborn.api.IIngredient;
import es.degrassi.mmreborn.api.PartialBlockState;
import es.degrassi.mmreborn.api.TagUtil;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;

public class BlockIngredient
implements IIngredient<PartialBlockState, BlockInWorld> {
    public static final BlockIngredient AIR = new BlockIngredient("air", false, PartialBlockState.AIR);
    public static final BlockIngredient ANY = new BlockIngredient("any", false, PartialBlockState.ANY);
    public static final BlockIngredient MACHINE = new BlockIngredient("machine", false, PartialBlockState.MACHINE);
    public static final BlockIngredient NOT_MACHINE = new BlockIngredient("not_machine", true, PartialBlockState.MACHINE);
    public static final BlockIngredient STRUCTURE_CHECKER = new BlockIngredient("structure_creator", false, PartialBlockState.STRUCTURE_CHECKER);
    public static final BlockIngredient NOT_STRUCTURE_CHECKER = new BlockIngredient("not_structure_creator", true, PartialBlockState.STRUCTURE_CHECKER);
    public static final NamedCodec<BlockIngredient> STRING_CODEC = NamedCodec.STRING.comapFlatMap(s -> {
        try {
            StringReader reader = new StringReader(s);
            reader.skipWhitespace();
            boolean not = false;
            if (!reader.getRemaining().contains("[") && reader.getRemaining().contains("]")) {
                reader = new StringReader(reader.getRemaining().replaceAll("]", ""));
            }
            if (reader.peek() == '!') {
                not = true;
                reader.skip();
            }
            if (reader.peek() == '[') {
                reader.skip();
                s = reader.readStringUntil(']');
            } else {
                s = reader.getRemaining();
            }
            String[] arr = s.split(", ");
            return DataResult.success((Object)Arrays.stream(arr).map(string -> {
                try {
                    return BlockIngredient.of(string);
                }
                catch (CommandSyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
            }).reduce(new BlockIngredient("", not, Collections.emptyList(), Collections.emptyList()), BlockIngredient::merge));
        }
        catch (CommandSyntaxException | IllegalArgumentException e) {
            return DataResult.error(((Exception)e)::getMessage);
        }
    }, BlockIngredient::getString, "BlockIngredient from string");
    public static final NamedCodec<BlockIngredient> ING_CODEC = NamedCodec.either(PartialBlockState.CODEC, STRING_CODEC, "Block Ingredient").listOf().flatComapMap(list -> {
        ArrayList ings = Lists.newArrayList();
        list.forEach(either -> ings.add((BlockIngredient)either.map(BlockIngredient::new, Function.identity())));
        AtomicReference<Object> ing = new AtomicReference<Object>(null);
        ings.iterator().forEachRemaining(i -> {
            if (ing.get() == null) {
                ing.set(i);
                return;
            }
            ing.set(((BlockIngredient)ing.get()).merge((BlockIngredient)i));
        });
        return ing.get();
    }, ing -> {
        ArrayList list = Lists.newArrayList();
        list.add(Either.right((Object)ing));
        return DataResult.success((Object)list);
    }, "Block Ingredient");
    public static final NamedCodec<BlockIngredient> MAP_CODEC = NamedCodec.record(blockIngredientInstance -> blockIngredientInstance.group(NamedCodec.BOOL.optionalFieldOf("not", false).forGetter(ingredient -> ingredient.not), ING_CODEC.fieldOf("ingredient").forGetter(Function.identity())).apply((Applicative)blockIngredientInstance, (not, ingredient) -> new BlockIngredient(ingredient.id, (boolean)not, ingredient.insertedTags, ingredient.insertedStates)), "Block ingredient");
    public static final NamedCodec<BlockIngredient> CODEC = NamedCodec.either(MAP_CODEC, STRING_CODEC).xmap(either -> (BlockIngredient)either.map(Function.identity(), Function.identity()), Either::left, "Block Ingredient");
    private final Supplier<List<PartialBlockState>> partialBlockStates;
    private List<TagKey<Block>> tags = Lists.newArrayList();
    private final boolean not;
    final List<TagKey<Block>> insertedTags;
    final List<PartialBlockState> insertedStates;
    private final String id;

    public BlockIngredient(String id, List<TagKey<Block>> tags, List<PartialBlockState> states) {
        this(id, false, tags, states);
    }

    public BlockIngredient(String id, boolean not, List<TagKey<Block>> tags, List<PartialBlockState> states) {
        ArrayList statesCopy = Lists.newArrayList(states);
        this.insertedStates = states;
        this.insertedTags = tags;
        this.tags.addAll(tags);
        this.not = not;
        tags.forEach(tag -> statesCopy.addAll(TagUtil.getBlocks((TagKey<Block>)tag).map(PartialBlockState::new).toList()));
        this.partialBlockStates = Suppliers.memoize(() -> ImmutableList.copyOf((Collection)statesCopy));
        this.id = id;
    }

    public BlockIngredient(String id, boolean not, PartialBlockState partialBlockState) {
        this(id, not, Collections.emptyList(), Collections.singletonList(partialBlockState));
    }

    public BlockIngredient(String id, PartialBlockState partialBlockState) {
        this(id, false, partialBlockState);
    }

    public BlockIngredient(PartialBlockState partialBlockState) {
        this("", partialBlockState);
    }

    public static BlockIngredient create(Object o) throws IllegalArgumentException, CommandSyntaxException {
        if (o instanceof List) {
            List sa = (List)o;
            return sa.stream().filter(s -> s instanceof CharSequence).map(s -> (CharSequence)s).map(s -> {
                try {
                    return BlockIngredient.of(s);
                }
                catch (CommandSyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
            }).reduce(new BlockIngredient("", false, Collections.emptyList(), Collections.emptyList()), BlockIngredient::merge);
        }
        if (!(o instanceof CharSequence)) {
            throw new IllegalArgumentException("Block ingredient must be a string or string[]");
        }
        CharSequence s2 = (CharSequence)o;
        return BlockIngredient.of(s2);
    }

    public BlockIngredient copy() {
        return new BlockIngredient(this.id, this.not, this.insertedTags.stream().map(TagKey::location).map(tag -> TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)tag)).toList(), this.insertedStates.stream().map(PartialBlockState::copy).toList());
    }

    @Override
    public List<PartialBlockState> getAll() {
        return this.partialBlockStates.get();
    }

    @Override
    public boolean test(BlockInWorld block) {
        boolean isTag = !this.insertedTags.isEmpty();
        boolean partial = false;
        if (isTag) {
            partial = this.not ? this.insertedTags.stream().noneMatch(tag -> block.getState().is(tag)) : this.insertedTags.stream().anyMatch(tag -> block.getState().is(tag));
        }
        if (this.not) {
            return partial || this.insertedStates.stream().noneMatch(state -> state.test(block));
        }
        return partial || this.insertedStates.stream().anyMatch(state -> state.test(block));
    }

    @Override
    public boolean test(Block block) {
        boolean isTag = !this.insertedTags.isEmpty();
        boolean partial = false;
        if (isTag) {
            partial = this.not ? this.insertedTags.stream().noneMatch(tag -> BuiltInRegistries.BLOCK.getTag(tag).map(named -> named.contains(Holder.direct((Object)block))).orElse(false)) : this.insertedTags.stream().anyMatch(tag -> BuiltInRegistries.BLOCK.getTag(tag).map(named -> named.contains(Holder.direct((Object)block))).orElse(false));
        }
        if (this.not) {
            return partial || this.insertedStates.stream().noneMatch(state -> state.getBlockState().getBlock() == block);
        }
        return partial || this.insertedStates.stream().anyMatch(state -> state.getBlockState().getBlock() == block);
    }

    public List<ItemStack> getStacks(int amount) {
        List<ItemStack> stacks = this.getTagStacks(amount);
        stacks.addAll(this.getNonTagStacks(amount));
        return stacks.stream().collect(Collectors.groupingBy(ItemStack::getItem, Collectors.summingInt(ItemStack::getCount))).entrySet().stream().map(entry -> new ItemStack((ItemLike)entry.getKey(), ((Integer)entry.getValue()).intValue())).toList();
    }

    public List<ItemStack> getNonTagStacks(int amount) {
        return this.insertedStates.stream().map(PartialBlockState::getBlockState).map(BlockBehaviour.BlockStateBase::getBlock).map(Block::asItem).map(Item::getDefaultInstance).map(stack -> stack.copyWithCount(amount)).toList();
    }

    public List<ItemStack> getTagStacks(int amount) {
        return Lists.newArrayList(this.insertedTags.stream().flatMap(TagUtil::getBlocks).map(Block::asItem).map(Item::getDefaultInstance).map(stack -> stack.copyWithCount(amount)).iterator());
    }

    public List<Component> getNames() {
        ArrayList ingredients = Lists.newArrayList();
        ingredients.addAll(this.insertedTags.stream().map(TagKey::location).map(ResourceLocation::toString).map(s -> "#" + s).map(Component::literal).toList());
        ingredients.addAll(this.insertedStates.stream().map(PartialBlockState::getName).toList());
        return ingredients;
    }

    public MutableComponent getNamesUnified() {
        MutableComponent name = Component.empty();
        Iterator<Component> iterator = this.getNames().iterator();
        if (this.not) {
            name.append((Component)Component.translatable((String)"modular_machinery_reborn.jei.ingredient.structure.not"));
        }
        while (iterator.hasNext()) {
            Component current = iterator.next();
            name.append(current);
            if (!iterator.hasNext()) continue;
            name.append((Component)Component.translatable((String)"modular_machinery_reborn.jei.ingredient.structure.or"));
        }
        return name;
    }

    public String getString() {
        HashSet ings = Sets.newHashSet();
        ings.addAll(this.insertedTags.stream().map(TagKey::location).map(ResourceLocation::toString).map(s -> "#" + s).toList());
        ings.addAll(this.insertedStates.stream().map(PartialBlockState::toString).toList());
        if (ings.size() == 1) {
            return (this.not ? "!" : "") + (String)ings.stream().toList().getFirst();
        }
        return (this.not ? "!" : "") + String.valueOf(ings);
    }

    public String toString() {
        return this.asJson().toString();
    }

    public BlockIngredient copyWithRotation(Rotation rotation) {
        return new BlockIngredient(this.id, this.not, this.insertedTags, this.insertedStates.stream().map(state -> state.copyWithRotation(rotation)).toList());
    }

    public BlockIngredient merge(BlockIngredient other) {
        if (other == null) {
            return AIR.merge(this);
        }
        HashSet ingredients = Sets.newHashSet();
        ingredients.addAll(this.insertedStates);
        ingredients.addAll(other.insertedStates);
        HashSet tags = Sets.newHashSet();
        tags.addAll(this.insertedTags);
        tags.addAll(other.insertedTags);
        Object i = this.id;
        if (!((String)i).isEmpty() && !other.id.isEmpty()) {
            i = (String)i + ",";
        }
        i = (String)i + other.id;
        return new BlockIngredient((String)i, other.not || this.not, tags.stream().toList(), ingredients.stream().toList());
    }

    @Override
    public JsonObject asJson() {
        JsonObject json = new JsonObject();
        json.addProperty("not", Boolean.valueOf(this.not));
        json.addProperty("tags", this.insertedTags.toString());
        JsonArray array = new JsonArray();
        this.insertedStates.forEach(state -> array.add(state.toString()));
        json.add("states", (JsonElement)array);
        return json;
    }

    public CompoundTag asTag() {
        CompoundTag tag = new CompoundTag();
        ListTag tagList = new ListTag();
        tag.putBoolean("not", this.not);
        this.insertedTags.forEach(t -> tagList.add((Object)StringTag.valueOf((String)t.toString())));
        tag.put("tags", (Tag)tagList);
        ListTag states = new ListTag();
        this.insertedStates.forEach(state -> states.add((Object)StringTag.valueOf((String)state.toString())));
        tag.put("states", (Tag)states);
        return tag;
    }

    public static BlockIngredient of(CharSequence s) throws CommandSyntaxException {
        StringReader reader = new StringReader(s.toString());
        reader.skipWhitespace();
        if (!reader.getRemaining().contains("[") && reader.getRemaining().contains("]")) {
            reader = new StringReader(reader.getRemaining().replaceAll("]", ""));
        }
        boolean not = false;
        if (reader.peek() == '!') {
            not = true;
            reader.skip();
        }
        if (reader.peek() == '#') {
            reader.skip();
            TagKey tag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)reader.getRemaining()));
            return new BlockIngredient("#" + String.valueOf(tag.location()), not, Collections.singletonList(tag), Collections.emptyList());
        }
        PartialBlockState state = PartialBlockState.of(reader.getRemaining());
        return new BlockIngredient(state.toString(), not, Collections.emptyList(), Collections.singletonList(state));
    }

    public boolean equals(Object o) {
        if (!(o instanceof BlockIngredient)) {
            return false;
        }
        BlockIngredient that = (BlockIngredient)o;
        return this.not == that.not && Objects.equals(this.insertedStates, that.insertedStates) && Objects.equals(this.insertedTags, that.insertedTags);
    }

    public int hashCode() {
        return Objects.hash(this.not, this.insertedStates, this.insertedTags);
    }

    @Generated
    public List<TagKey<Block>> getTags() {
        return this.tags;
    }

    @Generated
    public void setTags(List<TagKey<Block>> tags) {
        this.tags = tags;
    }

    @Generated
    public boolean isNot() {
        return this.not;
    }

    @Generated
    public String getId() {
        return this.id;
    }
}

