/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.villager.trades;

import com.almostreliable.morejs.features.villager.TradeItem;
import com.google.common.base.Preconditions;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;

public abstract class TransformableTrade<T extends VillagerTrades.ItemListing>
implements VillagerTrades.ItemListing {
    protected final TradeItem firstInput;
    protected final TradeItem secondInput;
    protected int maxUses = 16;
    protected int villagerExperience = 2;
    protected float priceMultiplier = 0.05f;
    @Nullable
    private Transformer transformer;

    public TransformableTrade(TradeItem[] inputs) {
        Preconditions.checkArgument((1 <= inputs.length && inputs.length <= 2 ? 1 : 0) != 0, (Object)"Inputs must be 1 or 2 items");
        this.firstInput = inputs[0];
        this.secondInput = inputs.length == 2 ? inputs[1] : TradeItem.EMPTY;
    }

    @Nullable
    public final MerchantOffer getOffer(Entity entity, RandomSource random) {
        MerchantOffer offer = this.createOffer(entity, random);
        if (offer == null) {
            return null;
        }
        if (this.transformer != null) {
            this.transformer.accept(offer, entity, random);
        }
        return offer;
    }

    @HideFromJS
    @Nullable
    public abstract MerchantOffer createOffer(Entity var1, RandomSource var2);

    public T transform(Transformer offerModification) {
        this.transformer = offerModification;
        return this.getSelf();
    }

    public T maxUses(int maxUses) {
        this.maxUses = maxUses;
        return this.getSelf();
    }

    public T villagerExperience(int villagerExperience) {
        this.villagerExperience = villagerExperience;
        return this.getSelf();
    }

    public T priceMultiplier(float priceMultiplier) {
        this.priceMultiplier = priceMultiplier;
        return this.getSelf();
    }

    protected T getSelf() {
        return (T)this;
    }

    protected MerchantOffer createOffer(ItemStack output, RandomSource random) {
        ItemCost fi = this.firstInput.createItemCost(random);
        Optional<Object> si = Optional.ofNullable(this.secondInput.isEmpty() ? null : this.secondInput.createItemCost(random));
        return new MerchantOffer(fi, si, output, this.maxUses, this.villagerExperience, this.priceMultiplier);
    }

    public TradeItem getFirstInput() {
        return this.firstInput;
    }

    public TradeItem getSecondInput() {
        return this.secondInput;
    }

    public static interface Transformer {
        public void accept(MerchantOffer var1, Entity var2, RandomSource var3);
    }
}

