/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.villager.events;

import com.almostreliable.morejs.features.villager.IntRange;
import com.almostreliable.morejs.features.villager.TradeFilter;
import com.almostreliable.morejs.features.villager.TradeItem;
import com.almostreliable.morejs.features.villager.TradeMatcher;
import com.almostreliable.morejs.features.villager.VillagerUtils;
import com.almostreliable.morejs.features.villager.trades.CustomTrade;
import com.almostreliable.morejs.features.villager.trades.SimpleTrade;
import com.almostreliable.morejs.features.villager.trades.TransformableTrade;
import com.google.common.base.Preconditions;
import com.google.common.collect.Table;
import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;

public class VillagerTradingEventJS
implements KubeEvent {
    private final Table<VillagerProfession, Integer, List<VillagerTrades.ItemListing>> trades;

    public VillagerTradingEventJS(Table<VillagerProfession, Integer, List<VillagerTrades.ItemListing>> allTrades) {
        this.trades = allTrades;
    }

    public List<VillagerTrades.ItemListing> getTrades(Holder<VillagerProfession> profession, int level) {
        Preconditions.checkArgument((1 <= level && level <= 5 ? 1 : 0) != 0, (Object)"Level must be between 1 and 5");
        Preconditions.checkArgument((!((VillagerProfession)profession.value()).equals((Object)VillagerProfession.NONE) ? 1 : 0) != 0, (Object)"No or invalid profession specified");
        return Objects.requireNonNull((List)this.trades.get(profession.value(), (Object)level));
    }

    public SimpleTrade addTrade(Holder<VillagerProfession> profession, int level, TradeItem[] inputs, TradeItem output) {
        Preconditions.checkArgument((!output.isEmpty() ? 1 : 0) != 0, (Object)"Sell item cannot be empty");
        Preconditions.checkArgument((inputs.length != 0 ? 1 : 0) != 0, (Object)"Buyer items cannot be empty");
        Preconditions.checkArgument((boolean)Arrays.stream(inputs).noneMatch(TradeItem::isEmpty), (Object)"Buyer items cannot be empty");
        SimpleTrade trade = VillagerUtils.createSimpleTrade(inputs, output);
        return this.addTrade(profession, level, trade);
    }

    public <T extends VillagerTrades.ItemListing> T addTrade(Holder<VillagerProfession> profession, int level, T trade) {
        Objects.requireNonNull(trade);
        this.getTrades(profession, level).add(trade);
        return trade;
    }

    public void addCustomTrade(Holder<VillagerProfession> profession, int level, TransformableTrade.Transformer transformer) {
        this.getTrades(profession, level).add(new CustomTrade(transformer));
    }

    public void removeTrades(TradeFilter filter) {
        this.forEachTrades((listings, level, profession) -> {
            TradeMatcher matcher = new TradeMatcher(filter, (first, second, output) -> {
                String secondStr = second == null || second.isEmpty() ? "" : " & " + String.valueOf(second);
                ResourceLocation profId = BuiltInRegistries.VILLAGER_PROFESSION.getKey((Object)profession);
                ConsoleJS.SERVER.info((Object)("Removing villager trade for profession '" + String.valueOf(profId) + "' for level " + level + ": " + String.valueOf(first) + secondStr + " -> " + String.valueOf(output)));
            });
            if (matcher.matchProfession(profession) && matcher.matchMerchantLevel(level)) {
                listings.removeIf(itemListing -> {
                    if (itemListing instanceof TradeMatcher.Filterable) {
                        TradeMatcher.Filterable filterable = (TradeMatcher.Filterable)itemListing;
                        return filterable.matchesTradeFilter(matcher);
                    }
                    return false;
                });
            }
        });
    }

    public void removeVanillaTypedTrades() {
        this.forEachTrades((listings, level, profession) -> listings.removeIf(VillagerUtils::isVanillaTypedTrade));
    }

    public void removeVanillaTypedTrades(List<Holder<VillagerProfession>> profession) {
        this.removeVanillaTypedTrades(profession, IntRange.all());
    }

    public void removeVanillaTypedTrades(List<Holder<VillagerProfession>> professions, IntRange intRange) {
        this.forEachTrades(professions, intRange, itemListings -> itemListings.removeIf(VillagerUtils::isVanillaTypedTrade));
    }

    public void removeModdedTypedTrades() {
        this.forEachTrades((listings, level, profession) -> listings.removeIf(VillagerUtils::isModdedTypedTrade));
    }

    public void removeModdedTypedTrades(List<Holder<VillagerProfession>> profession) {
        this.removeModdedTypedTrades(profession, IntRange.all());
    }

    public void removeModdedTypedTrades(List<Holder<VillagerProfession>> professions, IntRange intRange) {
        this.forEachTrades(professions, intRange, itemListings -> itemListings.removeIf(VillagerUtils::isModdedTypedTrade));
    }

    public void forEachTrades(ForEachCallback callback) {
        this.trades.rowMap().forEach((profession, tradesPerLevel) -> tradesPerLevel.forEach((level, itemListings) -> callback.accept((List<VillagerTrades.ItemListing>)itemListings, (int)level, (VillagerProfession)profession)));
    }

    public void forEachTrades(List<Holder<VillagerProfession>> professions, IntRange intRange, Consumer<List<VillagerTrades.ItemListing>> consumer) {
        Set filter = professions.stream().map(Holder::value).collect(Collectors.toSet());
        this.forEachTrades((itemListings, level, profession) -> {
            if (filter.contains(profession) && intRange.test(level)) {
                consumer.accept(itemListings);
            }
        });
    }

    public static interface ForEachCallback {
        public void accept(List<VillagerTrades.ItemListing> var1, int var2, VillagerProfession var3);
    }
}

