/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.structure;

import com.almostreliable.morejs.features.structure.StructureBlockInfoModification;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class PaletteWrapper {
    private final StructureTemplate.Palette palette;
    private final Vec3i borderSize;
    private final Map<BlockPos, StructureTemplate.StructureBlockInfo> cache = new HashMap<BlockPos, StructureTemplate.StructureBlockInfo>();

    public PaletteWrapper(StructureTemplate.Palette palette, Vec3i borderSize) {
        this.palette = palette;
        this.borderSize = borderSize;
    }

    public void clear() {
        this.palette.blocks().clear();
        this.cache.clear();
    }

    public void add(BlockPos pos, BlockState state) {
        this.add(pos, state, null);
    }

    public void add(BlockPos pos, BlockState state, @Nullable CompoundTag tag) {
        StructureTemplate.StructureBlockInfo info;
        Preconditions.checkNotNull((Object)pos, (Object)"Invalid position");
        Preconditions.checkNotNull((Object)state, (Object)"Invalid state");
        Preconditions.checkArgument((0 <= pos.getX() && pos.getX() < this.borderSize.getX() ? 1 : 0) != 0, (Object)("Invalid position, x must be between 0 and " + this.borderSize.getX()));
        Preconditions.checkArgument((0 <= pos.getX() && pos.getY() < this.borderSize.getY() ? 1 : 0) != 0, (Object)("Invalid position, y must be between 0 and " + this.borderSize.getY()));
        Preconditions.checkArgument((0 <= pos.getX() && pos.getZ() < this.borderSize.getZ() ? 1 : 0) != 0, (Object)("Invalid position, z must be between 0 and " + this.borderSize.getZ()));
        StructureTemplate.StructureBlockInfo structureBlockInfo = info = this.get(pos);
        if (structureBlockInfo instanceof StructureBlockInfoModification) {
            StructureBlockInfoModification mod = (StructureBlockInfoModification)structureBlockInfo;
            mod.setVanillaBlockState(state);
            mod.setNbt(tag);
            return;
        }
        StructureTemplate.StructureBlockInfo newInfo = new StructureTemplate.StructureBlockInfo(pos, state, tag);
        this.palette.blocks().add(newInfo);
        this.cache.put(pos, newInfo);
    }

    public void forEach(Consumer<StructureTemplate.StructureBlockInfo> consumer) {
        this.palette.blocks().forEach(consumer);
    }

    public void removeIf(Predicate<StructureTemplate.StructureBlockInfo> predicate) {
        this.palette.blocks().removeIf((? super E block) -> {
            if (predicate.test((StructureTemplate.StructureBlockInfo)block)) {
                this.cache.remove(block.pos());
                return true;
            }
            return false;
        });
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo get(BlockPos pos) {
        if (this.cache.isEmpty()) {
            this.forEach(info -> this.cache.put(info.pos(), (StructureTemplate.StructureBlockInfo)info));
        }
        return this.cache.get(pos);
    }
}

