/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs;

import com.almostreliable.morejs.features.villager.IntRange;
import com.almostreliable.morejs.features.villager.TradeItem;
import com.almostreliable.morejs.util.Utils;
import com.almostreliable.morejs.util.WeightedList;
import com.mojang.datafixers.util.Pair;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.ItemWrapper;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.StringUtilsWrapper;
import dev.latvian.mods.rhino.Context;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;

public class MoreJSBinding {
    @Nullable
    public static BlockPos findStructure(BlockPos position, ServerLevel level, HolderSet<Structure> structures, int chunkRadius) {
        Pair result = level.getChunkSource().getGenerator().findNearestMapStructure(level, structures, position, chunkRadius, true);
        if (result == null) {
            return null;
        }
        return (BlockPos)result.getFirst();
    }

    @Nullable
    public static BlockPos findBiome(BlockPos position, ServerLevel level, HolderSet<Biome> biomes, int chunkRadius) {
        Pair nearestBiome = level.findClosestBiome3d(arg_0 -> biomes.contains(arg_0), position, chunkRadius * 16, 32, 64);
        if (nearestBiome != null) {
            return (BlockPos)nearestBiome.getFirst();
        }
        return null;
    }

    public static WeightedList.Builder<Object> weightedList() {
        return new WeightedList.Builder<Object>();
    }

    public static IntRange range(@Nullable Object o) {
        if (o instanceof Number) {
            Number number = (Number)o;
            return new IntRange(number.intValue());
        }
        if (o instanceof List) {
            List list = (List)o;
            return switch (list.size()) {
                case 0 -> IntRange.all();
                case 1 -> MoreJSBinding.range(list.get(0));
                default -> new IntRange(StringUtilsWrapper.parseInt(list.get(0), (int)1), StringUtilsWrapper.parseInt(list.get(1), (int)5));
            };
        }
        return IntRange.all();
    }

    public static WeightedList<Object> ofWeightedList(@Nullable Object o) {
        if (o instanceof WeightedList.Builder) {
            WeightedList.Builder b = (WeightedList.Builder)o;
            return b.build();
        }
        if (o instanceof WeightedList) {
            return (WeightedList)Utils.cast(o);
        }
        WeightedList.Builder<Object> builder = new WeightedList.Builder<Object>();
        for (Object entry : Utils.asList(o)) {
            List<Object> weightValue = Utils.asList(entry);
            if (weightValue.size() == 2) {
                builder.add(StringUtilsWrapper.parseInt((Object)weightValue.get(0), (int)1), weightValue.get(1));
                continue;
            }
            builder.add(1, entry);
        }
        return builder.build();
    }

    public static TradeItem ofTradeItem(Context cx, @Nullable Object o) {
        if (o instanceof TradeItem) {
            TradeItem item = (TradeItem)o;
            return item;
        }
        return TradeItem.of(ItemWrapper.wrap((Context)cx, (Object)o));
    }
}

