/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.client;

import mrbysco.constructionstick.basics.option.IOption;
import mrbysco.constructionstick.basics.option.StickOptions;
import mrbysco.constructionstick.network.ModMessages;
import mrbysco.constructionstick.network.PacketStickOption;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class StickScreen
extends Screen {
    private final ItemStack stick;
    private final StickOptions stickOptions;
    private static final int BUTTON_WIDTH = 160;
    private static final int BUTTON_HEIGHT = 20;
    private static final int SPACING_WIDTH = 50;
    private static final int SPACING_HEIGHT = 30;
    private static final int N_COLS = 2;
    private static final int N_ROWS = 3;
    private static final int FIELD_WIDTH = 370;
    private static final int FIELD_HEIGHT = 120;

    public StickScreen(ItemStack stick) {
        super((Component)Component.literal((String)"StickScreen"));
        this.stick = stick;
        this.stickOptions = new StickOptions(stick);
    }

    protected void init() {
        this.createButton(0, 0, this.stickOptions.upgrades);
        this.createButton(0, 1, this.stickOptions.lock);
        this.createButton(0, 2, this.stickOptions.direction);
        this.createButton(1, 0, this.stickOptions.replace);
        this.createButton(1, 1, this.stickOptions.match);
        this.createButton(1, 2, this.stickOptions.random);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.font, this.stick.getDisplayName(), this.width / 2, this.height / 2 - 60 - 30, 0xFFFFFF);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (Minecraft.getInstance().options.keyInventory.matches(keyCode, scanCode)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private void createButton(int cx, int cy, IOption<?> option) {
        Button button = Button.builder((Component)this.getButtonLabel(option), bt -> this.clickButton(bt, option)).pos(this.getX(cx), this.getY(cy)).size(160, 20).tooltip(this.getButtonTooltip(option)).build();
        button.active = option.isEnabled();
        this.addRenderableWidget((GuiEventListener)button);
    }

    private void clickButton(Button button, IOption<?> option) {
        option.next();
        ModMessages.sendToServer(new PacketStickOption(option, false));
        button.setMessage(this.getButtonLabel(option));
        button.setTooltip(this.getButtonTooltip(option));
    }

    private int getX(int n) {
        return this.width / 2 - 185 + n * 210;
    }

    private int getY(int n) {
        return this.height / 2 - 60 + n * 50;
    }

    private Component getButtonLabel(IOption<?> option) {
        return Component.translatable((String)option.getKeyTranslation()).append((Component)Component.translatable((String)option.getValueTranslation()));
    }

    private Tooltip getButtonTooltip(IOption<?> option) {
        return Tooltip.create((Component)Component.translatable((String)option.getDescTranslation()));
    }
}

