/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.neoforge.worldgen.structures;

import com.kittehmod.ceilands.neoforge.registry.CeilandsProcessors;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class ChainProcessor
extends StructureProcessor {
    public static final MapCodec<ChainProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("max_height").forGetter(config -> config.maxHeight)).apply((Applicative)instance, instance.stable(ChainProcessor::new)));
    private final int maxHeight;

    private ChainProcessor(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader worldView, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings structurePlacementData) {
        BlockState blockState = structureBlockInfoWorld.state();
        BlockPos worldPos = structureBlockInfoWorld.pos();
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        random.setSeed(worldPos.asLong() * (long)worldPos.getY());
        CompoundTag nbt = structureBlockInfoWorld.nbt();
        return new StructureTemplate.StructureBlockInfo(worldPos, blockState, nbt);
    }

    protected StructureProcessorType<?> getType() {
        return CeilandsProcessors.HANGING_CHAINS;
    }
}

