/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.neoforge.worldgen.features.trunkplacers;

import com.google.common.collect.ImmutableList;
import com.kittehmod.ceilands.neoforge.registry.CeilandsTrunkPlacerType;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class LuzawoodTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<LuzawoodTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(func -> LuzawoodTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)func).apply((Applicative)func, LuzawoodTrunkPlacer::new));

    public LuzawoodTrunkPlacer(int p_70268_, int p_70269_, int p_70270_) {
        super(p_70268_, p_70269_, p_70270_);
    }

    protected TrunkPlacerType<?> type() {
        return CeilandsTrunkPlacerType.LUZAWOOD_TRUNK_PLACER;
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader reader, BiConsumer<BlockPos, BlockState> consumer, RandomSource random, int height, BlockPos pos, TreeConfiguration config) {
        LuzawoodTrunkPlacer.setDirtAt((LevelSimulatedReader)reader, consumer, (RandomSource)random, (BlockPos)pos.below(), (TreeConfiguration)config);
        int i = 0;
        for (i = 0; i < height; ++i) {
            this.placeLog(reader, consumer, random, pos.above(i), config);
        }
        int branchOutwardLength = 2 + random.nextInt(4);
        int branchOutwardHeight = 3 + random.nextInt(3);
        Direction.Axis rotation = (double)random.nextFloat() < 0.5 ? Direction.Axis.X : Direction.Axis.Z;
        this.placeLog(reader, consumer, random, pos.above(height), config, state -> (BlockState)state.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)rotation));
        for (i = 1; i <= branchOutwardLength; ++i) {
            if (rotation == Direction.Axis.X) {
                this.placeLog(reader, consumer, random, pos.above(height).east(i), config, state -> (BlockState)state.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)rotation));
                continue;
            }
            this.placeLog(reader, consumer, random, pos.above(height).north(i), config, state -> (BlockState)state.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)rotation));
        }
        for (i = 1; i <= branchOutwardLength; ++i) {
            if (rotation == Direction.Axis.X) {
                this.placeLog(reader, consumer, random, pos.above(height).west(i), config, state -> (BlockState)state.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)rotation));
                continue;
            }
            this.placeLog(reader, consumer, random, pos.above(height).south(i), config, state -> (BlockState)state.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)rotation));
        }
        for (i = 1; i <= branchOutwardHeight; ++i) {
            if (rotation == Direction.Axis.X) {
                this.placeLog(reader, consumer, random, pos.above(height + i).east(branchOutwardLength), config);
                continue;
            }
            this.placeLog(reader, consumer, random, pos.above(height + i).north(branchOutwardLength), config);
        }
        for (i = 1; i <= branchOutwardHeight; ++i) {
            if (rotation == Direction.Axis.X) {
                this.placeLog(reader, consumer, random, pos.above(height + i).west(branchOutwardLength), config);
                continue;
            }
            this.placeLog(reader, consumer, random, pos.above(height + i).south(branchOutwardLength), config);
        }
        if (rotation == Direction.Axis.X) {
            return ImmutableList.of((Object)new FoliagePlacer.FoliageAttachment(pos.above(height + branchOutwardHeight + 1).west(branchOutwardLength), 2, false), (Object)new FoliagePlacer.FoliageAttachment(pos.above(height + branchOutwardHeight + 1).east(branchOutwardLength), 2, false));
        }
        return ImmutableList.of((Object)new FoliagePlacer.FoliageAttachment(pos.above(height + branchOutwardHeight + 1).north(branchOutwardLength), 2, false), (Object)new FoliagePlacer.FoliageAttachment(pos.above(height + branchOutwardHeight + 1).south(branchOutwardLength), 2, false));
    }
}

