/*
 * Decompiled with CFR 0.152.
 */
package com.kittehmod.ceilands.neoforge.worldgen.features.trunkplacers;

import com.google.common.collect.ImmutableList;
import com.kittehmod.ceilands.neoforge.registry.CeilandsTrunkPlacerType;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class LargeCeiltrunkTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<LargeCeiltrunkTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(func -> LargeCeiltrunkTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)func).apply((Applicative)func, LargeCeiltrunkTrunkPlacer::new));
    public static final Direction[] STARTING_BRANCH_DIRECTION = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    public LargeCeiltrunkTrunkPlacer(int p_70268_, int p_70269_, int p_70270_) {
        super(p_70268_, p_70269_, p_70270_);
    }

    protected TrunkPlacerType<?> type() {
        return CeilandsTrunkPlacerType.LARGE_CEILTRUNK_TRUNK_PLACER;
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader reader, BiConsumer<BlockPos, BlockState> consumer, RandomSource random, int height, BlockPos pos, TreeConfiguration config) {
        BlockPos blockpos = pos.above();
        if (reader.isStateAtPosition(blockpos, blockstate -> blockstate.getBlock() != Blocks.GRASS_BLOCK)) {
            LargeCeiltrunkTrunkPlacer.setDirtAt((LevelSimulatedReader)reader, consumer, (RandomSource)random, (BlockPos)blockpos, (TreeConfiguration)config);
            LargeCeiltrunkTrunkPlacer.setDirtAt((LevelSimulatedReader)reader, consumer, (RandomSource)random, (BlockPos)blockpos.east(), (TreeConfiguration)config);
            LargeCeiltrunkTrunkPlacer.setDirtAt((LevelSimulatedReader)reader, consumer, (RandomSource)random, (BlockPos)blockpos.south(), (TreeConfiguration)config);
            LargeCeiltrunkTrunkPlacer.setDirtAt((LevelSimulatedReader)reader, consumer, (RandomSource)random, (BlockPos)blockpos.south().east(), (TreeConfiguration)config);
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        boolean spiralRotation = (double)random.nextFloat() < 0.5;
        int branchLength = 3 + random.nextInt(4);
        boolean branchOrientation = false;
        Direction dir = STARTING_BRANCH_DIRECTION[random.nextInt(4)];
        for (int i = 0; i < height; ++i) {
            if (i < height - 1) {
                this.placeLogIfFreeWithOffset(reader, consumer, random, blockpos$mutableblockpos, config, pos, 0, -i, 0);
                this.placeLogIfFreeWithOffset(reader, consumer, random, blockpos$mutableblockpos, config, pos, 1, -i, 0);
                this.placeLogIfFreeWithOffset(reader, consumer, random, blockpos$mutableblockpos, config, pos, 1, -i, 1);
                this.placeLogIfFreeWithOffset(reader, consumer, random, blockpos$mutableblockpos, config, pos, 0, -i, 1);
            }
            if (i < height - 4) {
                branchOrientation = (double)random.nextFloat() < 0.5;
                this.generateBranches(reader, consumer, random, blockpos$mutableblockpos, config, pos.below(i), dir, branchLength - 1, branchOrientation ? 0 : 1, dir == Direction.SOUTH || dir == Direction.EAST ? 1 : 0);
                dir = spiralRotation ? dir.getClockWise() : dir.getCounterClockWise();
            }
            if (i != height - 2) continue;
            branchOrientation = false;
            branchOrientation = (double)random.nextFloat() < 0.5;
            this.generateBranches(reader, consumer, random, blockpos$mutableblockpos, config, pos.below(i), Direction.NORTH, branchLength, branchOrientation ? 0 : 1, 0);
            branchOrientation = (double)random.nextFloat() < 0.5;
            this.generateBranches(reader, consumer, random, blockpos$mutableblockpos, config, pos.below(i), Direction.SOUTH, branchLength, branchOrientation ? 0 : 1, 1);
            branchOrientation = (double)random.nextFloat() < 0.5;
            this.generateBranches(reader, consumer, random, blockpos$mutableblockpos, config, pos.below(i), Direction.WEST, branchLength, branchOrientation ? 0 : 1, 0);
            branchOrientation = (double)random.nextFloat() < 0.5;
            this.generateBranches(reader, consumer, random, blockpos$mutableblockpos, config, pos.below(i), Direction.EAST, branchLength, branchOrientation ? 0 : 1, 1);
        }
        return height >= 3 ? ImmutableList.of((Object)new FoliagePlacer.FoliageAttachment(pos.below(height - 1), -1, true)) : ImmutableList.of();
    }

    private void placeLogIfFreeWithOffset(LevelSimulatedReader reader, BiConsumer<BlockPos, BlockState> consumer, RandomSource random, BlockPos.MutableBlockPos pos$mutable, TreeConfiguration config, BlockPos pos, int x, int y, int z) {
        pos$mutable.setWithOffset((Vec3i)pos, x, y, z);
        this.placeLogIfFree(reader, consumer, random, pos$mutable, config);
    }

    private void generateBranches(LevelSimulatedReader reader, BiConsumer<BlockPos, BlockState> consumer, RandomSource random, BlockPos.MutableBlockPos pos$mutable, TreeConfiguration config, BlockPos pos, Direction direction, int branchLength, int offset1, int offset2) {
        for (int bl = 1; bl <= branchLength; ++bl) {
            pos$mutable.set((Vec3i)pos);
            BlockPos finalizedPos = pos$mutable.relative(direction, bl + offset2).relative(Direction.UP, bl >= Math.abs(branchLength) ? 1 : 0).relative(direction == Direction.NORTH || direction == Direction.SOUTH ? Direction.EAST : Direction.SOUTH, offset1).immutable();
            if (!this.isFree(reader, finalizedPos)) continue;
            this.placeLog(reader, consumer, random, finalizedPos, config, blockstate -> (BlockState)blockstate.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)this.getLogAxis((BlockPos)pos$mutable, finalizedPos)));
        }
    }

    private Direction.Axis getLogAxis(BlockPos p_70130_, BlockPos p_70131_) {
        int j;
        Direction.Axis direction$axis = Direction.Axis.Y;
        int i = Math.abs(p_70131_.getX() - p_70130_.getX());
        int k = Math.max(i, j = Math.abs(p_70131_.getZ() - p_70130_.getZ()));
        if (k > 0) {
            direction$axis = i == k ? Direction.Axis.X : Direction.Axis.Z;
        }
        return direction$axis;
    }
}

